/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.spatial.arrange.fill;

import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.function.ToDoubleFunction;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.spatial.arrange.fill.ExtentToArrange;
import org.anchoranalysis.image.bean.spatial.arrange.fill.LinearPartition;

class Partitioner {
    public static List<List<ExtentToArrange>> partitionExtents(List<ExtentToArrange> elements, int numberBatches, boolean varyNumberImagesPerBatch, boolean batchIsRow) throws OperationFailedException {
        if (varyNumberImagesPerBatch) {
            ToDoubleFunction<ExtentToArrange> extractCost = batchIsRow ? ExtentToArrange::getAspectRatio : ExtentToArrange::aspectRatioInverted;
            return LinearPartition.partition(elements, extractCost, numberBatches);
        }
        return Partitioner.partitionIntoBatches(elements, numberBatches);
    }

    private static <T> List<List<T>> partitionIntoBatches(List<T> elements, int numberBatches) {
        ArrayList<List<T>> out = new ArrayList<List<T>>(numberBatches);
        int imagesPerBatch = (int)Math.ceil((double)elements.size() / (double)numberBatches);
        int count = 0;
        LinkedList<T> current = new LinkedList<T>();
        for (T element : elements) {
            current.add(element);
            if (++count != imagesPerBatch) continue;
            out.add(current);
            current = new LinkedList();
            count = 0;
        }
        if (count != 0) {
            out.add(current);
        }
        return out;
    }

    private Partitioner() {
    }
}

