/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.spatial.arrange.fill;

import com.github.davidmoten.guavamini.Preconditions;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Iterator;
import java.util.List;
import org.anchoranalysis.image.bean.spatial.arrange.fill.ExtentToArrange;

class ScaleElementsInRow {
    public static void scaleElementsToMatchRow(List<ExtentToArrange> row, int targetWidth, double aspectRatioSum) {
        int actualRowWidth = ScaleElementsInRow.scaleElementsToApproximatelyMatch(row, targetWidth, aspectRatioSum);
        ScaleElementsInRow.maybeAdjustElementWidth(row, targetWidth, actualRowWidth);
    }

    private static int scaleElementsToApproximatelyMatch(List<ExtentToArrange> row, int targetWidth, double aspectRatioSum) {
        int actualRowWidth = 0;
        for (ExtentToArrange element : row) {
            actualRowWidth += element.scaleToMatchRow(aspectRatioSum, targetWidth);
        }
        return actualRowWidth;
    }

    private static void maybeAdjustElementWidth(List<ExtentToArrange> row, int targetWidth, int actualWidth) {
        int difference = targetWidth - actualWidth;
        assert (Math.abs(difference) <= row.size());
        if (difference > 0) {
            ScaleElementsInRow.adjustElementWidth(row, difference, 1);
        } else if (difference < 0) {
            ScaleElementsInRow.adjustElementWidth(row, difference * -1, -1);
        }
    }

    private static void adjustElementWidth(List<ExtentToArrange> row, int numberElements, int adjustment) {
        Preconditions.checkArgument((numberElements <= row.size() ? 1 : 0) != 0);
        ArrayList<ExtentToArrange> sortedRow = new ArrayList<ExtentToArrange>(row);
        Collections.sort(sortedRow, Comparator.comparingDouble(extent -> (double)(-1 * adjustment) * extent.getScaleRoundingError()));
        Iterator iterator = sortedRow.iterator();
        while (numberElements > 0) {
            ExtentToArrange element = (ExtentToArrange)iterator.next();
            element.growWidth(adjustment);
            --numberElements;
        }
    }

    private ScaleElementsInRow() {
    }
}

