/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.spatial.arrange.tile;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.stream.Stream;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.image.bean.nonbean.spatial.arrange.ArrangeStackException;
import org.anchoranalysis.image.bean.nonbean.spatial.arrange.StackArrangement;
import org.anchoranalysis.image.bean.spatial.arrange.tile.ArrangerIndex;
import org.anchoranalysis.spatial.box.Extent;

class ArrangementIndex {
    private List<List<StackArrangement>> rows = new ArrayList<List<StackArrangement>>();
    private List<List<StackArrangement>> columns = new ArrayList<List<StackArrangement>>();

    public ArrangementIndex(Iterator<Extent> extents, ArrangerIndex arrangers, Extent tableSize, OperationContext context) throws ArrangeStackException {
        for (int row = 0; row < tableSize.y(); ++row) {
            for (int column = 0; column < tableSize.x(); ++column) {
                if (!extents.hasNext()) {
                    return;
                }
                StackArrangement item = arrangers.getForCell(column, row).arrangeStacks(extents, context);
                List currentRows = ArrangementIndex.getListOrAdd(this.rows, row);
                List currentColumns = ArrangementIndex.getListOrAdd(this.columns, column);
                currentRows.add(item);
                currentColumns.add(item);
            }
        }
    }

    public boolean isCellUsed(int columnIndex, int rowIndex) {
        if (rowIndex >= this.rows.size()) {
            return false;
        }
        return columnIndex < this.rows.get(rowIndex).size();
    }

    public StackArrangement get(int columnIndex, int rowIndex) {
        return this.rows.get(rowIndex).get(columnIndex);
    }

    public Stream<StackArrangement> getRow(int index) {
        return this.rows.get(index).stream();
    }

    public Stream<StackArrangement> getColumn(int index) {
        return this.columns.get(index).stream();
    }

    public int getNumberRows() {
        return this.rows.size();
    }

    public int getNumberColumns() {
        return this.columns.size();
    }

    private static <T> List<T> getListOrAdd(List<List<T>> list, int index) {
        if (index >= list.size()) {
            ArrayList current = new ArrayList();
            list.add(current);
            return current;
        }
        return list.get(index);
    }
}

