/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.spatial.arrange.tile;

import java.util.List;
import java.util.function.ToIntFunction;
import org.anchoranalysis.image.bean.nonbean.spatial.arrange.ArrangeStackException;
import org.anchoranalysis.image.bean.spatial.arrange.StackArranger;
import org.anchoranalysis.image.bean.spatial.arrange.tile.Cell;
import org.anchoranalysis.spatial.box.Extent;

class ArrangerIndex {
    private final Cell[][] index;
    private final StackArranger cellDefault;

    public ArrangerIndex(List<Cell> cells, StackArranger cellDefault, Extent tableSize) throws ArrangeStackException {
        this.index = new Cell[tableSize.y()][tableSize.x()];
        for (Cell cell : cells) {
            ArrangerIndex.checkDimension(cell, tableSize, Cell::getRow, Extent::y, "row");
            ArrangerIndex.checkDimension(cell, tableSize, Cell::getColumn, Extent::x, "column");
            if (this.index[cell.getRow()][cell.getColumn()] == null) {
                this.index[cell.getRow()][cell.getColumn()] = cell;
                continue;
            }
            throw new ArrangeStackException(String.format("Duplicated cell entries exist for the cell with column=%d and row=%d", cell.getColumn(), cell.getRow()));
        }
        this.cellDefault = cellDefault;
    }

    public StackArranger getForCell(int column, int row) {
        Cell cell = this.index[row][column];
        if (cell != null) {
            return cell.getArrange();
        }
        return this.cellDefault;
    }

    private static void checkDimension(Cell cell, Extent tableSize, ToIntFunction<Cell> fromCell, ToIntFunction<Extent> fromExtent, String entityName) throws ArrangeStackException {
        int dimensionValue = fromCell.applyAsInt(cell);
        if (dimensionValue < 0 || dimensionValue >= fromExtent.applyAsInt(tableSize)) {
            throw new ArrangeStackException(String.format("A cell exists with an invalid %s: %d", entityName, dimensionValue));
        }
    }
}

