/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.spatial.arrange.tile;

import com.github.davidmoten.guavamini.Preconditions;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.Positive;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.checked.CheckedUnaryOperator;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.image.bean.nonbean.spatial.arrange.ArrangeStackException;
import org.anchoranalysis.image.bean.nonbean.spatial.arrange.BoundingBoxEnclosed;
import org.anchoranalysis.image.bean.nonbean.spatial.arrange.StackArrangement;
import org.anchoranalysis.image.bean.spatial.arrange.Single;
import org.anchoranalysis.image.bean.spatial.arrange.StackArranger;
import org.anchoranalysis.image.bean.spatial.arrange.align.Align;
import org.anchoranalysis.image.bean.spatial.arrange.align.BoxAligner;
import org.anchoranalysis.image.bean.spatial.arrange.tile.ArrangementIndex;
import org.anchoranalysis.image.bean.spatial.arrange.tile.ArrangerIndex;
import org.anchoranalysis.image.bean.spatial.arrange.tile.Cell;
import org.anchoranalysis.image.bean.spatial.arrange.tile.CellSizeCalculator;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;

public class Tile
extends StackArranger {
    @BeanField
    @Positive
    private int numberColumns = 1;
    @BeanField
    @Positive
    private int numberRows = 1;
    @BeanField
    private List<Cell> cells = new ArrayList<Cell>();
    @BeanField
    private StackArranger cellDefault = new Single();
    @BeanField
    private BoxAligner aligner = new Align();

    public Tile(int numberColumns, int numberRows) {
        Preconditions.checkArgument((numberColumns > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((numberRows > 0 ? 1 : 0) != 0);
        this.numberColumns = numberColumns;
        this.numberRows = numberRows;
    }

    @Override
    public StackArrangement arrangeStacks(Iterator<Extent> extents, OperationContext context) throws ArrangeStackException {
        Extent tableSize = new Extent(this.numberColumns, this.numberRows, 1);
        ArrangerIndex arrangers = new ArrangerIndex(this.cells, this.cellDefault, tableSize);
        ArrangementIndex table = new ArrangementIndex(extents, arrangers, tableSize, context);
        return this.createArrangement(table, new CellSizeCalculator(table));
    }

    private StackArrangement createArrangement(ArrangementIndex table, CellSizeCalculator cellSizes) throws ArrangeStackException {
        StackArrangement arrangement = new StackArrangement(cellSizes.total());
        for (int row = 0; row < table.getNumberRows(); ++row) {
            for (int column = 0; column < table.getNumberColumns(); ++column) {
                if (!table.isCellUsed(column, row)) continue;
                StackArrangement stacksInCell = table.get(column, row);
                BoundingBox cell = cellSizes.cell(column, row);
                Tile.addAll(stacksInCell, arrangement, (CheckedUnaryOperator<BoundingBoxEnclosed, OperationFailedException>)((CheckedUnaryOperator)box -> new BoundingBoxEnclosed(this.aligner.align(box.getBox(), cell), cell)));
            }
        }
        return arrangement;
    }

    private static void addAll(Iterable<BoundingBoxEnclosed> source, StackArrangement destination, CheckedUnaryOperator<BoundingBoxEnclosed, OperationFailedException> mapBox) throws ArrangeStackException {
        for (BoundingBoxEnclosed box : source) {
            assert (destination.extent().contains(box.getBox()));
            assert (!box.getBox().extent().anyDimensionIsLargerThan(destination.extent()));
            try {
                destination.add((BoundingBoxEnclosed)mapBox.apply((Object)box));
            }
            catch (OperationFailedException e) {
                throw new ArrangeStackException("Invalid values on the z-dimension exist for the cell alignment.");
            }
        }
    }

    public Tile() {
    }

    public int getNumberColumns() {
        return this.numberColumns;
    }

    public void setNumberColumns(int numberColumns) {
        this.numberColumns = numberColumns;
    }

    public int getNumberRows() {
        return this.numberRows;
    }

    public void setNumberRows(int numberRows) {
        this.numberRows = numberRows;
    }

    public List<Cell> getCells() {
        return this.cells;
    }

    public void setCells(List<Cell> cells) {
        this.cells = cells;
    }

    public StackArranger getCellDefault() {
        return this.cellDefault;
    }

    public void setCellDefault(StackArranger cellDefault) {
        this.cellDefault = cellDefault;
    }

    public BoxAligner getAligner() {
        return this.aligner;
    }

    public void setAligner(BoxAligner aligner) {
        this.aligner = aligner;
    }
}

