/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.threshold;

import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.threshold.CalculateLevel;
import org.anchoranalysis.image.bean.threshold.Thresholder;
import org.anchoranalysis.image.core.object.HistogramFromObjectsFactory;
import org.anchoranalysis.image.voxel.VoxelsUntyped;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.binary.values.BinaryValuesByte;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.image.voxel.thresholder.VoxelsThresholder;
import org.anchoranalysis.math.histogram.Histogram;

public class ThresholderGlobal
extends Thresholder {
    @BeanField
    private CalculateLevel calculateLevel;

    @Override
    public BinaryVoxels<UnsignedByteBuffer> threshold(VoxelsUntyped inputBuffer, BinaryValuesByte bvOut, Optional<Histogram> histogram, Optional<ObjectMask> objectMask) throws OperationFailedException {
        return this.thresholdForHistogram(this.histogramBuffer(inputBuffer, histogram, objectMask), inputBuffer, bvOut, objectMask);
    }

    private BinaryVoxels<UnsignedByteBuffer> thresholdForHistogram(Histogram histogram, VoxelsUntyped inputBuffer, BinaryValuesByte bvOut, Optional<ObjectMask> objectMask) throws OperationFailedException {
        int thresholdVal = this.calculateLevel.calculateLevel(histogram);
        assert (thresholdVal >= 0);
        return VoxelsThresholder.threshold((VoxelsUntyped)inputBuffer, (float)thresholdVal, (BinaryValuesByte)bvOut, objectMask, (boolean)false);
    }

    private Histogram histogramBuffer(VoxelsUntyped inputBuffer, Optional<Histogram> histogram, Optional<ObjectMask> objectMask) {
        return histogram.orElseGet(() -> HistogramFromObjectsFactory.createFrom((VoxelsUntyped)inputBuffer, (Optional)objectMask));
    }

    public ThresholderGlobal() {
    }

    public ThresholderGlobal(CalculateLevel calculateLevel) {
        this.calculateLevel = calculateLevel;
    }

    public CalculateLevel getCalculateLevel() {
        return this.calculateLevel;
    }

    public void setCalculateLevel(CalculateLevel calculateLevel) {
        this.calculateLevel = calculateLevel;
    }
}

