/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.unitvalue.distance;

import java.util.Optional;
import org.anchoranalysis.bean.annotation.AllowEmpty;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.unitvalue.distance.UnitValueDistance;
import org.anchoranalysis.image.core.dimensions.SpatialUnits;
import org.anchoranalysis.image.core.dimensions.UnitConverter;
import org.anchoranalysis.spatial.orientation.DirectionVector;

public class DistancePhysical
extends UnitValueDistance {
    private static final long serialVersionUID = 1L;
    @BeanField
    private double value;
    @BeanField
    @AllowEmpty
    private String unitType;

    @Override
    public double resolve(Optional<UnitConverter> unitConverter, DirectionVector direction) throws OperationFailedException {
        if (unitConverter.isPresent()) {
            double valueAsBase = SpatialUnits.convertFromUnits((double)this.value, (String)this.unitType);
            return unitConverter.get().fromPhysicalDistance(valueAsBase, direction);
        }
        throw new OperationFailedException("Image-resolution is missing, so cannot calculate physical distances");
    }

    public double getValue() {
        return this.value;
    }

    public void setValue(double value) {
        this.value = value;
    }

    public String getUnitType() {
        return this.unitType;
    }

    public void setUnitType(String unitType) {
        this.unitType = unitType;
    }
}

