/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.channel;

import java.util.Optional;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.image.bean.nonbean.ConsistentChannelChecker;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.Dimensions;

public abstract class ChannelAggregator
extends AnchorBean<ChannelAggregator> {
    private boolean ignoreResolution = false;
    private ConsistentChannelChecker checker = new ConsistentChannelChecker();

    public synchronized void addChannel(Channel channel, Logger logger) throws OperationFailedException {
        Optional<Dimensions> existing = this.existingDimensions();
        this.checker.checkChannelType(channel);
        if (existing.isPresent() && !this.areDimensionsEqual(channel.dimensions(), existing.get())) {
            if (existing.get().extent().equals((Object)channel.dimensions().extent())) {
                logger.messageLogger().logFormatted("Dropping image-resolution as it is not consistent between images: existing %s versus %s to add", new Object[]{existing.get().resolution(), channel.resolution()});
                this.ignoreResolution = true;
            } else {
                throw new OperationFailedException(String.format("Sizes of added-channel (%s) and aggregated-channel must be equal (%s)", channel.dimensions().extent(), existing.get().extent()));
            }
        }
        this.addChannelAfterCheck(channel);
    }

    public Channel aggregatedChannel() throws OperationFailedException {
        if (!this.existingDimensions().isPresent()) {
            throw new OperationFailedException("No channels have been added, so cannot create aggregation");
        }
        return this.retrieveCreateAggregatedChannel();
    }

    protected abstract Optional<Dimensions> existingDimensions();

    protected abstract void addChannelAfterCheck(Channel var1) throws OperationFailedException;

    protected abstract Channel retrieveCreateAggregatedChannel();

    protected Dimensions maybeDropResolution(Dimensions dimensions) {
        if (this.ignoreResolution) {
            return dimensions.duplicateChangeResolution(Optional.empty());
        }
        return dimensions;
    }

    private boolean areDimensionsEqual(Dimensions existing, Dimensions toAdd) {
        if (this.ignoreResolution) {
            return existing.extent().equals((Object)toAdd.extent());
        }
        return existing.equals((Object)toAdd);
    }
}

