/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.nonbean.init;

import java.util.Optional;
import java.util.Set;
import java.util.stream.Stream;
import org.anchoranalysis.core.identifier.provider.NamedProvider;
import org.anchoranalysis.core.identifier.provider.NamedProviderBridge;
import org.anchoranalysis.core.identifier.provider.NamedProviderCombine;
import org.anchoranalysis.core.identifier.provider.NamedProviderGetException;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.factory.ChannelFactorySingleType;
import org.anchoranalysis.image.core.channel.factory.ChannelFactoryUnsignedByte;
import org.anchoranalysis.image.core.dimensions.IncorrectImageSizeException;
import org.anchoranalysis.image.core.mask.Mask;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.BoundingBox;

class CombineStackProviders
implements NamedProvider<Stack> {
    private static final ChannelFactorySingleType FACTORY = new ChannelFactoryUnsignedByte();
    private final NamedProvider<Stack> combined;

    public CombineStackProviders(NamedProvider<Stack> stacks, NamedProvider<Channel> channels, NamedProvider<Mask> masks) {
        this.combined = new NamedProviderCombine(Stream.of(stacks, CombineStackProviders.convertChannels(channels), CombineStackProviders.convertMasks(masks)));
    }

    public Optional<Stack> getOptional(String key) throws NamedProviderGetException {
        return this.combined.getOptional(key);
    }

    public Set<String> keys() {
        return this.combined.keys();
    }

    private static NamedProviderBridge<Channel, Stack> convertChannels(NamedProvider<Channel> channels) {
        return new NamedProviderBridge(channels, Stack::new, false);
    }

    private static NamedProviderBridge<Mask, Stack> convertMasks(NamedProvider<Mask> masks) {
        return new NamedProviderBridge(masks, CombineStackProviders::stackFromMask, false);
    }

    private static Stack stackFromMask(Mask sourceObject) {
        Channel channelNew;
        block2: {
            channelNew = FACTORY.createEmptyInitialised(sourceObject.dimensions());
            BinaryVoxels voxels = sourceObject.binaryVoxels();
            ObjectMask object = voxels.voxels().extract().voxelsEqualTo(voxels.binaryValues().getOn()).deriveObject(new BoundingBox(voxels.extent()));
            try {
                channelNew.replaceVoxels(object.voxels());
            }
            catch (IncorrectImageSizeException e) {
                if ($assertionsDisabled) break block2;
                throw new AssertionError();
            }
        }
        return new Stack(channelNew);
    }
}

