/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.provider.stack;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import lombok.Generated;
import org.anchoranalysis.bean.Provider;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.DefaultInstance;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.image.bean.interpolator.Interpolator;
import org.anchoranalysis.image.bean.nonbean.spatial.arrange.ArrangeStackException;
import org.anchoranalysis.image.bean.provider.stack.StackProvider;
import org.anchoranalysis.image.bean.spatial.arrange.StackArranger;
import org.anchoranalysis.image.core.channel.factory.ChannelFactorySingleType;
import org.anchoranalysis.image.core.channel.factory.ChannelFactoryUnsignedByte;
import org.anchoranalysis.image.core.channel.factory.ChannelFactoryUnsignedShort;
import org.anchoranalysis.image.core.dimensions.IncorrectImageSizeException;
import org.anchoranalysis.image.core.stack.RGBStack;
import org.anchoranalysis.image.core.stack.Stack;

public class Arrange
extends StackProvider {
    @BeanField
    private List<Provider<Stack>> list = Arrays.asList(new Provider[0]);
    @BeanField
    private StackArranger arrange;
    @BeanField
    private boolean forceRGB = false;
    @BeanField
    private boolean createShort = false;
    @BeanField
    @DefaultInstance
    private Interpolator interpolator;

    public Arrange(boolean createShort, boolean forceRGB) {
        this.createShort = createShort;
        this.forceRGB = forceRGB;
    }

    public void addStack(Provider<Stack> provider) {
        this.list.add(provider);
    }

    public Stack get() throws ProvisionFailedException {
        if (this.list.isEmpty()) {
            throw new ProvisionFailedException("At least one stack must be present in list");
        }
        ArrayList<RGBStack> rasterList = new ArrayList<RGBStack>();
        for (Provider<Stack> provider : this.list) {
            Stack stack = (Stack)provider.get();
            if (this.forceRGB) {
                this.copyFirstChannelUntilThree(stack);
            }
            rasterList.add(new RGBStack(stack));
        }
        try {
            ChannelFactoryUnsignedShort factory = this.createShort ? new ChannelFactoryUnsignedShort() : new ChannelFactoryUnsignedByte();
            return this.arrange.combine(rasterList, this.interpolator.voxelsResizer(), (ChannelFactorySingleType)factory, new OperationContext(this.getLogger())).asStack();
        }
        catch (ArrangeStackException e) {
            throw new ProvisionFailedException((Throwable)((Object)e));
        }
    }

    private void copyFirstChannelUntilThree(Stack stack) {
        while (stack.getNumberChannels() < 3) {
            try {
                stack.addChannel(stack.getChannel(0).duplicate());
            }
            catch (IncorrectImageSizeException e) {
                assert (false);
            }
        }
    }

    @Generated
    public Arrange() {
    }

    @Generated
    public List<Provider<Stack>> getList() {
        return this.list;
    }

    @Generated
    public void setList(List<Provider<Stack>> list) {
        this.list = list;
    }

    @Generated
    public StackArranger getArrange() {
        return this.arrange;
    }

    @Generated
    public void setArrange(StackArranger arrange) {
        this.arrange = arrange;
    }

    @Generated
    public boolean isForceRGB() {
        return this.forceRGB;
    }

    @Generated
    public void setForceRGB(boolean forceRGB) {
        this.forceRGB = forceRGB;
    }

    @Generated
    public boolean isCreateShort() {
        return this.createShort;
    }

    @Generated
    public void setCreateShort(boolean createShort) {
        this.createShort = createShort;
    }

    @Generated
    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    @Generated
    public void setInterpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
    }
}

