/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.spatial.arrange.align;

import java.util.function.ToIntFunction;
import lombok.Generated;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.bean.nonbean.spatial.align.AlignmentOnDimension;
import org.anchoranalysis.image.bean.nonbean.spatial.align.PositionChoicesConstants;
import org.anchoranalysis.image.bean.spatial.arrange.align.BoxAligner;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class Align
extends BoxAligner {
    @BeanField
    private String alignX = "center";
    @BeanField
    private String alignY = "center";
    @BeanField
    private String alignZ = "center";
    private AlignmentOnDimension alignXEnum;
    private AlignmentOnDimension alignYEnum;
    private AlignmentOnDimension alignZEnum;

    public Align(String alignX, String alignY, String alignZ) {
        this.alignX = alignX;
        this.alignY = alignY;
        this.alignZ = alignZ;
    }

    public void checkMisconfigured(BeanInstanceMap defaultInstances) throws BeanMisconfiguredException {
        super.checkMisconfigured(defaultInstances);
        this.alignXEnum = PositionChoicesConstants.alignX(this.alignX);
        this.alignYEnum = PositionChoicesConstants.alignY(this.alignY);
        this.alignZEnum = PositionChoicesConstants.alignZ(this.alignZ);
    }

    @Override
    protected BoundingBox alignAfterCheck(BoundingBox smaller, BoundingBox larger) {
        ReadableTuple3i cornerLarger = larger.cornerMin();
        Point3i cornerAligned = this.alignCorner(smaller, larger.extent());
        cornerAligned.add(cornerLarger);
        return BoundingBox.createReuse((ReadableTuple3i)cornerAligned, (Extent)smaller.extent());
    }

    @Override
    protected BoundingBox alignAfterCheck(Extent smaller, Extent larger) throws OperationFailedException {
        Point3i cornerAligned = this.alignCorner(smaller, larger);
        return BoundingBox.createReuse((ReadableTuple3i)cornerAligned, (Extent)smaller);
    }

    @Override
    protected BoundingBox alignAfterCheck(Extent smaller, BoundingBox larger) throws OperationFailedException {
        ReadableTuple3i cornerLarger = larger.cornerMin();
        Point3i cornerAligned = this.alignCorner(smaller, larger.extent());
        cornerAligned.add(cornerLarger);
        return BoundingBox.createReuse((ReadableTuple3i)cornerAligned, (Extent)smaller);
    }

    private Point3i alignCorner(Extent smaller, Extent larger) {
        return new Point3i(Align.position(this.alignXEnum, Extent::x, smaller, 0, larger), Align.position(this.alignYEnum, Extent::y, smaller, 0, larger), Align.position(this.alignZEnum, Extent::z, smaller, 0, larger));
    }

    public Point3i alignCorner(BoundingBox smaller, Extent larger) {
        return new Point3i(Align.position(this.alignXEnum, Extent::x, smaller.extent(), smaller.cornerMin().x(), larger), Align.position(this.alignYEnum, Extent::y, smaller.extent(), smaller.cornerMin().y(), larger), Align.position(this.alignZEnum, Extent::z, smaller.extent(), smaller.cornerMin().z(), larger));
    }

    public Align duplicateBean() {
        Align duplicated = (Align)((Object)super.duplicateBean());
        duplicated.alignXEnum = this.alignXEnum;
        duplicated.alignYEnum = this.alignYEnum;
        duplicated.alignZEnum = this.alignZEnum;
        return duplicated;
    }

    private static int position(AlignmentOnDimension alignment, ToIntFunction<Extent> extractValue, Extent smaller, int disconsideredLeft, Extent larger) {
        return alignment.align(extractValue.applyAsInt(larger), extractValue.applyAsInt(smaller), disconsideredLeft);
    }

    @Generated
    public Align() {
    }

    @Generated
    public String getAlignX() {
        return this.alignX;
    }

    @Generated
    public void setAlignX(String alignX) {
        this.alignX = alignX;
    }

    @Generated
    public String getAlignY() {
        return this.alignY;
    }

    @Generated
    public void setAlignY(String alignY) {
        this.alignY = alignY;
    }

    @Generated
    public String getAlignZ() {
        return this.alignZ;
    }

    @Generated
    public void setAlignZ(String alignZ) {
        this.alignZ = alignZ;
    }
}

