/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.spatial.arrange.align;

import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public abstract class BoxAligner
extends AnchorBean<BoxAligner> {
    public BoundingBox align(BoundingBox smaller, BoundingBox larger) throws OperationFailedException {
        BoxAligner.checkCorner(smaller.cornerMin());
        BoxAligner.checkExtent(smaller.extent(), larger.extent());
        return this.alignAfterCheck(smaller, larger);
    }

    public BoundingBox align(Extent smaller, Extent larger) throws OperationFailedException {
        BoxAligner.checkExtent(smaller, larger);
        return this.alignAfterCheck(smaller, larger);
    }

    public BoundingBox align(Extent smaller, BoundingBox larger) throws OperationFailedException {
        BoxAligner.checkExtent(smaller, larger.extent());
        return this.alignAfterCheck(smaller, larger);
    }

    protected abstract BoundingBox alignAfterCheck(BoundingBox var1, BoundingBox var2) throws OperationFailedException;

    protected abstract BoundingBox alignAfterCheck(Extent var1, Extent var2) throws OperationFailedException;

    protected abstract BoundingBox alignAfterCheck(Extent var1, BoundingBox var2) throws OperationFailedException;

    private static void checkCorner(ReadableTuple3i smaller) throws OperationFailedException {
        if (smaller.z() != 0) {
            throw new OperationFailedException(String.format("The smaller bounding-box does not have 0 position in the z-dimension, rather: %d", smaller.z()));
        }
    }

    private static void checkExtent(Extent smaller, Extent larger) throws OperationFailedException {
        if (smaller.z() != larger.z()) {
            throw new OperationFailedException(String.format("The smaller and larger bounding-boxes do not have identical sizes in the z-dimension, respectively: %d and %d", smaller.z(), larger.z()));
        }
    }
}

