/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.spatial.arrange.fill;

import java.util.Arrays;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import lombok.Generated;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.NonNegative;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.bean.initializable.CheckMisconfigured;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.image.bean.nonbean.spatial.arrange.ArrangeStackException;
import org.anchoranalysis.image.bean.nonbean.spatial.arrange.BoundingBoxEnclosed;
import org.anchoranalysis.image.bean.nonbean.spatial.arrange.StackArrangement;
import org.anchoranalysis.image.bean.spatial.arrange.StackArranger;
import org.anchoranalysis.image.bean.spatial.arrange.fill.CombinedWidthCalculator;
import org.anchoranalysis.image.bean.spatial.arrange.fill.ExtentToArrange;
import org.anchoranalysis.image.bean.spatial.arrange.fill.FitCombinedScaler;
import org.anchoranalysis.image.bean.spatial.arrange.fill.Partitioner;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

public class Fill
extends StackArranger {
    @BeanField
    private int numberRows = 1;
    @BeanField
    private boolean varyNumberImagesPerRow = true;
    @BeanField
    @NonNegative
    private int width = 0;
    @BeanField
    @NonNegative
    private double widthRatio = 0.1;

    public Fill(int rows) {
        this.numberRows = rows;
    }

    public void checkMisconfigured(BeanInstanceMap defaultInstances) throws BeanMisconfiguredException {
        super.checkMisconfigured(defaultInstances);
        CheckMisconfigured.atLeastOne((String)"width", (String)"widthRatio", (this.width > 0 ? 1 : 0) != 0, (this.widthRatio > 0.0 ? 1 : 0) != 0);
    }

    @Override
    public StackArrangement arrangeStacks(Iterator<Extent> extents, OperationContext context) throws ArrangeStackException {
        List<ExtentToArrange> elements = Fill.createElements(extents);
        int numberRowsMin = Math.min(this.numberRows, elements.size());
        try {
            List partitions = (List)context.getExecutionTimeRecorder().recordExecutionTime("Partition extents", () -> Partitioner.partitionExtents(elements, numberRowsMin, this.varyNumberImagesPerRow, true));
            Extent combinedSize = this.scaleToTargetWidth(partitions);
            BoundingBox[] boxes = Fill.derivingBoundingBoxes(elements.size(), partitions, combinedSize);
            List boxesEnclosed = FunctionalList.mapToList(Arrays.stream(boxes), BoundingBoxEnclosed::new);
            return new StackArrangement(combinedSize, boxesEnclosed);
        }
        catch (OperationFailedException e) {
            throw new ArrangeStackException("An error occurred partitioning the elements", (Exception)((Object)e));
        }
    }

    private Extent scaleToTargetWidth(List<List<ExtentToArrange>> partitions) {
        int combinedWidth = CombinedWidthCalculator.calculate(partitions, this.width, this.widthRatio);
        return FitCombinedScaler.scaleToWidth(partitions, !this.varyNumberImagesPerRow, combinedWidth);
    }

    private static List<ExtentToArrange> createElements(Iterator<Extent> extents) {
        int index = 0;
        LinkedList<ExtentToArrange> elements = new LinkedList<ExtentToArrange>();
        while (extents.hasNext()) {
            elements.add(new ExtentToArrange(index++, extents.next()));
        }
        return elements;
    }

    private static BoundingBox[] derivingBoundingBoxes(int numberElements, List<List<ExtentToArrange>> partitions, Extent combinedSize) throws OperationFailedException {
        BoundingBox[] boxes = new BoundingBox[numberElements];
        Point3i cornerMin = new Point3i();
        for (List<ExtentToArrange> row : partitions) {
            cornerMin.setX(0);
            Extent extent = null;
            assert (!row.isEmpty());
            for (ExtentToArrange element : row) {
                BoundingBox box;
                extent = element.getExtent();
                if (!combinedSize.contains((ReadableTuple3i)cornerMin)) {
                    throw new OperationFailedException(String.format("Element %d with corner %s is not located inside the montaged image of size %s", element.getIndex(), cornerMin, combinedSize));
                }
                boxes[element.getIndex()] = box = BoundingBox.createDuplicate((ReadableTuple3i)cornerMin, (Extent)extent).clampTo(combinedSize);
                cornerMin.incrementX(extent.x());
            }
            cornerMin.incrementY(extent.y());
        }
        return boxes;
    }

    @Generated
    public Fill() {
    }

    @Generated
    public Fill(int numberRows, boolean varyNumberImagesPerRow, int width, double widthRatio) {
        this.numberRows = numberRows;
        this.varyNumberImagesPerRow = varyNumberImagesPerRow;
        this.width = width;
        this.widthRatio = widthRatio;
    }

    @Generated
    public int getNumberRows() {
        return this.numberRows;
    }

    @Generated
    public void setNumberRows(int numberRows) {
        this.numberRows = numberRows;
    }

    @Generated
    public boolean isVaryNumberImagesPerRow() {
        return this.varyNumberImagesPerRow;
    }

    @Generated
    public void setVaryNumberImagesPerRow(boolean varyNumberImagesPerRow) {
        this.varyNumberImagesPerRow = varyNumberImagesPerRow;
    }

    @Generated
    public int getWidth() {
        return this.width;
    }

    @Generated
    public void setWidth(int width) {
        this.width = width;
    }

    @Generated
    public double getWidthRatio() {
        return this.widthRatio;
    }

    @Generated
    public void setWidthRatio(double widthRatio) {
        this.widthRatio = widthRatio;
    }
}

