/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.bean.spatial.arrange.overlay;

import java.util.Iterator;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.image.bean.nonbean.spatial.arrange.ArrangeStackException;
import org.anchoranalysis.image.bean.nonbean.spatial.arrange.StackArrangement;
import org.anchoranalysis.image.bean.spatial.arrange.Single;
import org.anchoranalysis.image.bean.spatial.arrange.StackArranger;
import org.anchoranalysis.image.bean.spatial.arrange.align.Align;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;

public class Overlay
extends StackArranger {
    private static final Single SINGLE = new Single();
    @BeanField
    private Align align = new Align("left", "top", "bottom");

    public Overlay(String alignX, String alignY, String alignZ) {
        this.align = new Align(alignX, alignY, alignZ);
    }

    public String describeBean() {
        return this.getBeanName();
    }

    @Override
    public StackArrangement arrangeStacks(Iterator<Extent> extents, OperationContext context) throws ArrangeStackException {
        if (!extents.hasNext()) {
            throw new ArrangeStackException("No image in iterator for source");
        }
        StackArrangement arrangement = SINGLE.arrangeStacks(extents, context);
        if (!extents.hasNext()) {
            throw new ArrangeStackException("No image in iterator for overlay");
        }
        BoundingBox box = this.boxForOverlay(arrangement.extent(), extents.next());
        arrangement.add(box);
        return arrangement;
    }

    private BoundingBox boxForOverlay(Extent enclosing, Extent overlay) throws ArrangeStackException {
        try {
            if (this.align.getAlignZ().equalsIgnoreCase("repeat")) {
                BoundingBox boxAligned = this.align.align(overlay.flattenZ(), enclosing.flattenZ());
                if (overlay.z() != 1) {
                    throw new ArrangeStackException(String.format("If alignZ is `repeat` then the overlay must have a single z-slice, but it has %d slices.", overlay.z()));
                }
                return boxAligned.changeExtent(extentToChange -> extentToChange.duplicateChangeZ(enclosing.z()));
            }
            return this.align.align(overlay, enclosing);
        }
        catch (OperationFailedException e) {
            throw new ArrangeStackException("Failed to align the overlay with the enclosing stack", (Exception)((Object)e));
        }
    }

    @Generated
    public Overlay() {
    }

    @Generated
    public Overlay(Align align) {
        this.align = align;
    }

    @Generated
    public Align getAlign() {
        return this.align;
    }

    @Generated
    public void setAlign(Align align) {
        this.align = align;
    }
}

