/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.feature.bean.evaluator;

import java.util.Optional;
import org.anchoranalysis.bean.BeanInstanceMap;
import org.anchoranalysis.bean.Provider;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.annotation.SkipInit;
import org.anchoranalysis.bean.exception.BeanMisconfiguredException;
import org.anchoranalysis.bean.initializable.CheckMisconfigured;
import org.anchoranalysis.bean.shared.dictionary.DictionaryProvider;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.bean.FeatureRelatedBean;
import org.anchoranalysis.feature.bean.provider.FeatureProvider;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorSingle;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorSingleChangeInput;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.feature.initialization.FeatureRelatedInitialization;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.session.FeatureSession;
import org.anchoranalysis.feature.shared.SharedFeatures;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.feature.bean.evaluator.EnergyStackHelper;

public class FeatureEvaluator<T extends FeatureInput>
extends FeatureRelatedBean<FeatureEvaluator<T>> {
    @BeanField
    @OptionalBean
    @SkipInit
    private Feature<T> feature;
    @BeanField
    @OptionalBean
    private FeatureProvider<T> featureProvider;
    @BeanField
    @OptionalBean
    private Provider<Stack> stackEnergy;
    @BeanField
    @OptionalBean
    private DictionaryProvider dictionary;

    public void checkMisconfigured(BeanInstanceMap defaultInstances) throws BeanMisconfiguredException {
        super.checkMisconfigured(defaultInstances);
        CheckMisconfigured.oneOnly((String)"feature", (String)"featureProvider", (this.feature != null ? 1 : 0) != 0, (this.featureProvider != null ? 1 : 0) != 0);
    }

    public FeatureCalculatorSingle<T> createFeatureSession() throws OperationFailedException {
        return this.maybeAddEnergyStack(this.createCalculator());
    }

    public Optional<EnergyStack> energyStack() throws OperationFailedException {
        return EnergyStackHelper.energyStack(this.stackEnergy, this.dictionary);
    }

    private FeatureCalculatorSingle<T> createCalculator() throws OperationFailedException {
        try {
            return FeatureSession.with(this.determineFeature(), (SharedFeatures)((FeatureRelatedInitialization)this.getInitialization()).getSharedFeatures(), (Logger)this.getLogger());
        }
        catch (ProvisionFailedException | InitializeException e) {
            throw new OperationFailedException(e);
        }
    }

    private Feature<T> determineFeature() throws ProvisionFailedException {
        if (this.featureProvider != null) {
            return (Feature)this.featureProvider.get();
        }
        return this.feature;
    }

    private FeatureCalculatorSingle<T> maybeAddEnergyStack(FeatureCalculatorSingle<T> calculator) throws OperationFailedException {
        if (this.stackEnergy != null) {
            Optional<EnergyStack> energyStack = this.energyStack();
            return new FeatureCalculatorSingleChangeInput(calculator, input -> EnergyStackHelper.maybeSetEnergyStackOnInput(input, energyStack));
        }
        return calculator;
    }

    public Feature<T> getFeature() {
        return this.feature;
    }

    public void setFeature(Feature<T> feature) {
        this.feature = feature;
    }

    public FeatureProvider<T> getFeatureProvider() {
        return this.featureProvider;
    }

    public void setFeatureProvider(FeatureProvider<T> featureProvider) {
        this.featureProvider = featureProvider;
    }

    public Provider<Stack> getStackEnergy() {
        return this.stackEnergy;
    }

    public void setStackEnergy(Provider<Stack> stackEnergy) {
        this.stackEnergy = stackEnergy;
    }

    public DictionaryProvider getDictionary() {
        return this.dictionary;
    }

    public void setDictionary(DictionaryProvider dictionary) {
        this.dictionary = dictionary;
    }
}

