/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.feature.bean.evaluator;

import java.util.Arrays;
import java.util.List;
import java.util.function.UnaryOperator;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.identifier.provider.store.SharedObjects;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.feature.bean.FeatureRelatedBean;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.bean.list.FeatureListFactory;
import org.anchoranalysis.feature.bean.provider.FeatureProvider;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorMulti;
import org.anchoranalysis.feature.initialization.FeatureInitialization;
import org.anchoranalysis.feature.initialization.FeatureRelatedInitialization;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.session.FeatureSession;
import org.anchoranalysis.feature.shared.SharedFeatures;
import org.anchoranalysis.image.feature.calculator.NamedFeatureCalculatorMulti;

public class FeatureListEvaluator<T extends FeatureInput>
extends FeatureRelatedBean<FeatureListEvaluator<T>> {
    @BeanField
    private List<FeatureProvider<T>> features = Arrays.asList(new FeatureProvider[0]);

    public NamedFeatureCalculatorMulti<T> createFeatureSession(UnaryOperator<FeatureList<T>> addFeatures, SharedObjects sharedObjects) throws OperationFailedException {
        try {
            FeatureList featuresCreated = (FeatureList)addFeatures.apply(FeatureListFactory.fromProviders(this.features));
            if (featuresCreated.size() == 0) {
                throw new OperationFailedException("No features are set");
            }
            FeatureCalculatorMulti calculator = FeatureSession.with((FeatureList)featuresCreated, (FeatureInitialization)new FeatureInitialization(sharedObjects), (SharedFeatures)((FeatureRelatedInitialization)this.getInitialization()).getSharedFeatures(), (Logger)this.getLogger());
            return new NamedFeatureCalculatorMulti(calculator, featuresCreated.deriveNames());
        }
        catch (ProvisionFailedException | InitializeException e) {
            throw new OperationFailedException(e);
        }
    }

    public List<FeatureProvider<T>> getFeatures() {
        return this.features;
    }

    public void setFeatures(List<FeatureProvider<T>> features) {
        this.features = features;
    }
}

