/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.feature.bean.histogram;

import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.image.feature.bean.FeatureHistogram;
import org.anchoranalysis.image.feature.input.FeatureInputHistogram;
import org.anchoranalysis.math.histogram.Histogram;

public abstract class FeatureHistogramStatistic
extends FeatureHistogram {
    @BeanField
    private boolean exceptionIfEmpty = true;
    @BeanField
    private double valueIfEmpty = 0.0;

    public double calculate(FeatureCalculationInput<FeatureInputHistogram> input) throws FeatureCalculationException {
        Histogram histogram = ((FeatureInputHistogram)input.get()).getHistogram();
        if (histogram.isEmpty()) {
            if (this.exceptionIfEmpty) {
                throw new FeatureCalculationException("Histogram is empty, so abandoning feature calculation.");
            }
            return this.valueIfEmpty;
        }
        return this.calculateStatisticFrom(histogram);
    }

    protected abstract double calculateStatisticFrom(Histogram var1) throws FeatureCalculationException;

    public boolean isExceptionIfEmpty() {
        return this.exceptionIfEmpty;
    }

    public void setExceptionIfEmpty(boolean exceptionIfEmpty) {
        this.exceptionIfEmpty = exceptionIfEmpty;
    }

    public double getValueIfEmpty() {
        return this.valueIfEmpty;
    }

    public void setValueIfEmpty(double valueIfEmpty) {
        this.valueIfEmpty = valueIfEmpty;
    }
}

