/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.feature.bean.object.single;

import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.image.feature.bean.object.single.FeatureSingleObject;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.spatial.axis.Axis;
import org.anchoranalysis.spatial.axis.AxisConversionException;
import org.anchoranalysis.spatial.axis.AxisConverter;

public class CenterOfGravity
extends FeatureSingleObject {
    @BeanField
    private String axis = "x";
    @BeanField
    private double emptyValue = 0.0;

    public CenterOfGravity(Axis axis) {
        this.axis = axis.toString().toLowerCase();
    }

    public double calculate(FeatureCalculationInput<FeatureInputSingleObject> input) throws FeatureCalculationException {
        double val = ((FeatureInputSingleObject)input.get()).getObject().centerOfGravity(this.axis());
        if (Double.isNaN(val)) {
            return this.emptyValue;
        }
        return val;
    }

    private Axis axis() throws FeatureCalculationException {
        try {
            return AxisConverter.createFromString((String)this.axis);
        }
        catch (AxisConversionException e) {
            throw new FeatureCalculationException(e.friendlyMessageHierarchy());
        }
    }

    public CenterOfGravity() {
    }

    public String getAxis() {
        return this.axis;
    }

    public void setAxis(String axis) {
        this.axis = axis;
    }

    public double getEmptyValue() {
        return this.emptyValue;
    }

    public void setEmptyValue(double emptyValue) {
        this.emptyValue = emptyValue;
    }
}

