/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.feature.bean.physical;

import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.input.FeatureInputWithResolution;
import org.anchoranalysis.image.core.dimensions.Resolution;
import org.anchoranalysis.image.core.dimensions.SpatialUnits;
import org.anchoranalysis.image.core.dimensions.UnitConverter;
import org.anchoranalysis.image.feature.bean.physical.WithResolutionBase;

public abstract class FeatureConvertUnits<T extends FeatureInputWithResolution>
extends WithResolutionBase<T> {
    @BeanField
    private String unitType;

    protected FeatureConvertUnits(Feature<T> feature, SpatialUnits.UnitSuffix unitType) {
        super(feature);
        this.unitType = SpatialUnits.suffixStringForMeters((SpatialUnits.UnitSuffix)unitType);
    }

    @Override
    protected double calculateWithResolution(double value, Resolution resolution) throws FeatureCalculationException {
        double valuePhysical = this.convertToPhysical(value, resolution.unitConvert());
        return this.convertToUnits(valuePhysical);
    }

    protected abstract double convertToPhysical(double var1, UnitConverter var3) throws FeatureCalculationException;

    private double convertToUnits(double valuePhysical) {
        return SpatialUnits.convertToUnits((double)valuePhysical, (String)this.unitType);
    }

    public FeatureConvertUnits() {
    }

    public String getUnitType() {
        return this.unitType;
    }

    public void setUnitType(String unitType) {
        this.unitType = unitType;
    }
}

