/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.feature.bean.physical;

import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.bean.operator.FeatureUnaryGeneric;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.calculate.FeatureCalculationInput;
import org.anchoranalysis.feature.input.FeatureInputWithResolution;
import org.anchoranalysis.image.core.dimensions.Resolution;

public abstract class WithResolutionBase<T extends FeatureInputWithResolution>
extends FeatureUnaryGeneric<T> {
    @BeanField
    private boolean acceptMissingResolution = false;

    protected WithResolutionBase(Feature<T> feature) {
        super(feature);
    }

    public final double calculate(FeatureCalculationInput<T> input) throws FeatureCalculationException {
        double value = input.calculate(this.getItem());
        if (this.acceptMissingResolution) {
            Optional resolution = ((FeatureInputWithResolution)input.get()).getResolutionOptional();
            if (resolution.isPresent()) {
                return this.calculateWithResolution(value, (Resolution)resolution.get());
            }
            return Double.NaN;
        }
        return this.calculateWithResolution(value, ((FeatureInputWithResolution)input.get()).getResolutionRequired());
    }

    protected abstract double calculateWithResolution(double var1, Resolution var3) throws FeatureCalculationException;

    public WithResolutionBase() {
    }

    public boolean isAcceptMissingResolution() {
        return this.acceptMissingResolution;
    }

    public void setAcceptMissingResolution(boolean acceptMissingResolution) {
        this.acceptMissingResolution = acceptMissingResolution;
    }
}

