/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.feature.calculator.merged;

import java.util.Optional;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.feature.calculate.NamedFeatureCalculateException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorMulti;
import org.anchoranalysis.feature.results.ResultsVector;
import org.anchoranalysis.feature.session.replace.BoundReplaceStrategy;
import org.anchoranalysis.feature.session.replace.CacheAndReuseStrategy;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.feature.calculator.merged.CachingStrategies;
import org.anchoranalysis.image.feature.calculator.merged.CreateCalculatorHelper;
import org.anchoranalysis.image.feature.calculator.merged.MergedPairsFeatures;
import org.anchoranalysis.image.feature.calculator.merged.MergedPairsInclude;
import org.anchoranalysis.image.feature.calculator.merged.ResultsVectorBuilder;
import org.anchoranalysis.image.feature.calculator.merged.TransferSourceHelper;
import org.anchoranalysis.image.feature.input.FeatureInputPairObjects;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.feature.input.FeatureInputStack;

class CombinedCalculator {
    private final MergedPairsFeatures features;
    private final CreateCalculatorHelper calculatorCreator;
    private final MergedPairsInclude include;
    private final FeatureCalculatorMulti<FeatureInputStack> calculatorImage;
    private final Optional<FeatureCalculatorMulti<FeatureInputSingleObject>> calculatorFirstSecond;
    private final Optional<FeatureCalculatorMulti<FeatureInputSingleObject>> calculatorMerged;
    private final FeatureCalculatorMulti<FeatureInputPairObjects> calculatorPair;

    public CombinedCalculator(MergedPairsFeatures features, CreateCalculatorHelper calculatorCreator, MergedPairsInclude include, ImageInitialization initialization) throws InitializeException {
        this.calculatorCreator = calculatorCreator;
        this.features = features;
        this.include = include;
        this.calculatorImage = features.createCalculator(calculatorCreator, initialization, CachingStrategies.cacheAndReuse());
        BoundReplaceStrategy cachingStrategyFirstSecond = CachingStrategies.cacheAndReuse();
        this.calculatorFirstSecond = this.createFirstAndSecond(initialization, cachingStrategyFirstSecond);
        BoundReplaceStrategy cachingStrategyMerged = CachingStrategies.cacheAndReuse();
        this.calculatorMerged = this.createMerged(initialization, cachingStrategyMerged);
        this.calculatorPair = this.createPair(initialization, cachingStrategyFirstSecond, cachingStrategyMerged);
    }

    public ResultsVector calculateForInput(FeatureInputPairObjects input, Optional<ErrorReporter> errorReporter) throws NamedFeatureCalculateException {
        ResultsVectorBuilder helper = new ResultsVectorBuilder(this.sizeFeatures(), errorReporter);
        helper.calculateAndInsert(new FeatureInputStack(), this.calculatorImage);
        if (this.include.includeFirst()) {
            helper.calculateAndInsert(input, FeatureInputPairObjects::getFirst, this.calculatorFirstSecond.get());
        }
        if (this.include.includeSecond()) {
            helper.calculateAndInsert(input, FeatureInputPairObjects::getSecond, this.calculatorFirstSecond.get());
        }
        if (this.include.includeMerged()) {
            helper.calculateAndInsert(input, FeatureInputPairObjects::getMerged, this.calculatorMerged.get());
        }
        helper.calculateAndInsert(input, this.calculatorPair);
        return helper.getResultsVector();
    }

    public int sizeFeatures() {
        int numSingle = 1 + CombinedCalculator.integerFromBoolean(this.include.includeFirst()) + CombinedCalculator.integerFromBoolean(this.include.includeSecond());
        return this.features.numberImageFeatures() + this.features.numberPairFeatures() + numSingle * this.features.numberSingleFeatures();
    }

    private Optional<FeatureCalculatorMulti<FeatureInputSingleObject>> createFirstAndSecond(ImageInitialization initialization, BoundReplaceStrategy<FeatureInputSingleObject, CacheAndReuseStrategy<FeatureInputSingleObject>> cachingStrategyFirstSecond) throws InitializeException {
        if (this.include.includeFirstOrSecond()) {
            return Optional.of(this.features.createSingle(this.calculatorCreator, initialization, cachingStrategyFirstSecond));
        }
        return Optional.empty();
    }

    private Optional<FeatureCalculatorMulti<FeatureInputSingleObject>> createMerged(ImageInitialization initialization, BoundReplaceStrategy<FeatureInputSingleObject, CacheAndReuseStrategy<FeatureInputSingleObject>> cachingStrategyMerged) throws InitializeException {
        if (this.include.includeMerged()) {
            return Optional.of(this.features.createSingle(this.calculatorCreator, initialization, cachingStrategyMerged));
        }
        return Optional.empty();
    }

    private FeatureCalculatorMulti<FeatureInputPairObjects> createPair(ImageInitialization initialization, BoundReplaceStrategy<FeatureInputSingleObject, CacheAndReuseStrategy<FeatureInputSingleObject>> cachingStrategyFirstSecond, BoundReplaceStrategy<FeatureInputSingleObject, CacheAndReuseStrategy<FeatureInputSingleObject>> cachingStrategyMerged) throws InitializeException {
        return this.features.createPair(this.calculatorCreator, initialization, TransferSourceHelper.createTransferSource(cachingStrategyFirstSecond, cachingStrategyMerged));
    }

    private static int integerFromBoolean(boolean b) {
        return b ? 1 : 0;
    }
}

