/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.feature.calculator.merged;

import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.bean.list.FeatureListFactory;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorMulti;
import org.anchoranalysis.feature.session.cache.finder.CacheTransferSourceCollection;
import org.anchoranalysis.feature.session.replace.BoundReplaceStrategy;
import org.anchoranalysis.feature.session.replace.CacheAndReuseStrategy;
import org.anchoranalysis.feature.session.replace.ReplaceStrategy;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.feature.calculator.merged.CreateCalculatorHelper;
import org.anchoranalysis.image.feature.input.FeatureInputPairObjects;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.feature.input.FeatureInputStack;

public class MergedPairsFeatures {
    private FeatureList<FeatureInputStack> image;
    private FeatureList<FeatureInputSingleObject> single;
    private FeatureList<FeatureInputPairObjects> pair;

    public MergedPairsFeatures(FeatureList<FeatureInputPairObjects> pair) {
        this((FeatureList<FeatureInputStack>)FeatureListFactory.empty(), (FeatureList<FeatureInputSingleObject>)FeatureListFactory.empty(), pair);
    }

    public MergedPairsFeatures(FeatureList<FeatureInputStack> image, FeatureList<FeatureInputSingleObject> single, FeatureList<FeatureInputPairObjects> pair) {
        this.image = image;
        this.single = single;
        this.pair = pair;
    }

    public MergedPairsFeatures duplicate() {
        return new MergedPairsFeatures((FeatureList<FeatureInputStack>)((FeatureList)this.image.duplicateBean()), (FeatureList<FeatureInputSingleObject>)((FeatureList)this.single.duplicateBean()), (FeatureList<FeatureInputPairObjects>)((FeatureList)this.pair.duplicateBean()));
    }

    public int numberImageFeatures() {
        return this.image.size();
    }

    public int numberSingleFeatures() {
        return this.single.size();
    }

    public int numberPairFeatures() {
        return this.pair.size();
    }

    public FeatureCalculatorMulti<FeatureInputStack> createCalculator(CreateCalculatorHelper calculatorCreator, ImageInitialization initialization, BoundReplaceStrategy<FeatureInputStack, ? extends ReplaceStrategy<FeatureInputStack>> cachingStrategy) throws InitializeException {
        return calculatorCreator.createCached(this.getImage(), initialization, cachingStrategy);
    }

    public FeatureCalculatorMulti<FeatureInputSingleObject> createSingle(CreateCalculatorHelper calculatorCreator, ImageInitialization initialization, BoundReplaceStrategy<FeatureInputSingleObject, CacheAndReuseStrategy<FeatureInputSingleObject>> cachingStrategy) throws InitializeException {
        return calculatorCreator.createCached(this.getSingle(), initialization, cachingStrategy);
    }

    public FeatureCalculatorMulti<FeatureInputPairObjects> createPair(CreateCalculatorHelper calculatorCreator, ImageInitialization initialization, CacheTransferSourceCollection cacheTransferSource) throws InitializeException {
        return calculatorCreator.createPair(this.getPair(), initialization, cacheTransferSource);
    }

    public FeatureList<FeatureInputStack> getImage() {
        return this.image;
    }

    public FeatureList<FeatureInputSingleObject> getSingle() {
        return this.single;
    }

    public FeatureList<FeatureInputPairObjects> getPair() {
        return this.pair;
    }
}

