/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.feature.calculator.merged;

import java.util.Optional;
import java.util.function.Function;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.feature.calculate.NamedFeatureCalculateException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorMulti;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.results.ResultsVector;
import org.anchoranalysis.image.feature.input.FeatureInputPairObjects;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.voxel.object.ObjectMask;

class ResultsVectorBuilder {
    private Optional<ErrorReporter> errorReporter;
    private ResultsVector vector;
    private int count;

    public ResultsVectorBuilder(int size, Optional<ErrorReporter> errorReporter) {
        this.errorReporter = errorReporter;
        this.vector = new ResultsVector(size);
        this.count = 0;
    }

    public void calculateAndInsert(FeatureInputPairObjects inputPair, Function<FeatureInputPairObjects, ObjectMask> extractObj, FeatureCalculatorMulti<FeatureInputSingleObject> calculator) throws NamedFeatureCalculateException {
        FeatureInputSingleObject inputSingle = new FeatureInputSingleObject(extractObj.apply(inputPair));
        this.calculateAndInsert(inputSingle, calculator);
    }

    public <T extends FeatureInput> void calculateAndInsert(T input, FeatureCalculatorMulti<T> calculator) throws NamedFeatureCalculateException {
        ResultsVector vectorLocal = this.errorReporter.isPresent() ? calculator.calculateSuppressErrors(input, this.errorReporter.get()) : calculator.calculate(input);
        this.vector.set(this.count, vectorLocal);
        this.count += vectorLocal.size();
    }

    public ResultsVector getResultsVector() {
        return this.vector;
    }
}

