/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.feature.bean.evaluator;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.OptionalProviderFactory;
import org.anchoranalysis.bean.Provider;
import org.anchoranalysis.bean.shared.dictionary.DictionaryProvider;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.value.Dictionary;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.feature.input.FeatureInputEnergy;
import org.anchoranalysis.image.core.stack.Stack;

class EnergyStackHelper {
    public static Optional<EnergyStack> energyStack(Provider<Stack> stackEnergy, DictionaryProvider dictionary) throws OperationFailedException {
        try {
            if (stackEnergy != null) {
                EnergyStack energyStack = new EnergyStack((Stack)stackEnergy.get());
                energyStack.setParameters(OptionalProviderFactory.create((Provider)dictionary).orElseGet(Dictionary::new));
                return Optional.of(energyStack);
            }
            return Optional.empty();
        }
        catch (ProvisionFailedException e) {
            throw new OperationFailedException((Throwable)e);
        }
    }

    public static <T> void maybeSetEnergyStackOnInput(T input, Optional<EnergyStack> energyStack) {
        if (input instanceof FeatureInputEnergy) {
            FeatureInputEnergy inputCast = (FeatureInputEnergy)input;
            if (energyStack.isPresent()) {
                inputCast.setEnergyStack(energyStack.get());
            }
        }
    }

    @Generated
    private EnergyStackHelper() {
    }
}

