/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.feature.bean.physical;

import lombok.Generated;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.calculate.FeatureCalculationException;
import org.anchoranalysis.feature.initialization.FeatureInitialization;
import org.anchoranalysis.feature.input.FeatureInputWithResolution;
import org.anchoranalysis.image.bean.spatial.direction.DirectionVectorBean;
import org.anchoranalysis.image.bean.spatial.direction.SpecifyVector;
import org.anchoranalysis.image.core.dimensions.SpatialUnits;
import org.anchoranalysis.image.core.dimensions.UnitConverter;
import org.anchoranalysis.image.feature.bean.physical.FeatureConvertUnits;
import org.anchoranalysis.spatial.orientation.DirectionVector;

public class ConvertToPhysicalDistance<T extends FeatureInputWithResolution>
extends FeatureConvertUnits<T> {
    @BeanField
    private DirectionVectorBean direction = new SpecifyVector(1.0, 0.0, 0.0);
    private DirectionVector vectorInDirection;

    public ConvertToPhysicalDistance(Feature<T> feature, SpatialUnits.UnitSuffix unitType, DirectionVector directionVector) {
        super(feature, unitType);
        this.direction = new SpecifyVector(directionVector);
    }

    protected void beforeCalc(FeatureInitialization initialization) throws InitializeException {
        super.beforeCalc(initialization);
        try {
            this.vectorInDirection = this.direction.createVector();
        }
        catch (CreateException e) {
            throw new InitializeException((Throwable)e);
        }
    }

    @Override
    protected double convertToPhysical(double value, UnitConverter unitConverter) throws FeatureCalculationException {
        return unitConverter.toPhysicalDistance(value, this.vectorInDirection);
    }

    @Generated
    public ConvertToPhysicalDistance() {
    }

    @Generated
    public DirectionVectorBean getDirection() {
        return this.direction;
    }

    @Generated
    public void setDirection(DirectionVectorBean direction) {
        this.direction = direction;
    }
}

