/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.feature.calculator;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.calculate.NamedFeatureCalculateException;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorMulti;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.feature.initialization.FeatureInitialization;
import org.anchoranalysis.feature.input.FeatureInput;
import org.anchoranalysis.feature.name.FeatureNameList;
import org.anchoranalysis.feature.results.ResultsVector;
import org.anchoranalysis.feature.session.FeatureSession;
import org.anchoranalysis.feature.shared.SharedFeatures;
import org.anchoranalysis.feature.store.NamedFeatureStore;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.feature.calculator.FeatureTableCalculator;
import org.anchoranalysis.image.feature.calculator.InitializationFactory;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;

public class SingleTableCalculator
implements FeatureTableCalculator<FeatureInputSingleObject> {
    private final NamedFeatureStore<FeatureInputSingleObject> namedFeatureStore;
    private FeatureCalculatorMulti<FeatureInputSingleObject> calculator;

    @Override
    public void start(ImageInitialization initialization, Optional<EnergyStack> energyStack, Logger logger) throws InitializeException {
        this.calculator = FeatureSession.with((FeatureList)this.namedFeatureStore.features(), (FeatureInitialization)InitializationFactory.create(Optional.of(initialization.sharedObjects()), energyStack), (SharedFeatures)initialization.featuresInitialization().getSharedFeatures(), (Logger)logger);
    }

    @Override
    public FeatureTableCalculator<FeatureInputSingleObject> duplicateForNewThread() {
        return new SingleTableCalculator((NamedFeatureStore<FeatureInputSingleObject>)this.namedFeatureStore.duplicate());
    }

    public ResultsVector calculate(FeatureInputSingleObject input) throws NamedFeatureCalculateException {
        return this.calculator.calculate((FeatureInput)input);
    }

    public ResultsVector calculate(FeatureInputSingleObject input, FeatureList<FeatureInputSingleObject> featuresSubset) throws NamedFeatureCalculateException {
        return this.calculator.calculate((FeatureInput)input, featuresSubset);
    }

    public ResultsVector calculateSuppressErrors(FeatureInputSingleObject input, ErrorReporter errorReporter) {
        return this.calculator.calculateSuppressErrors((FeatureInput)input, errorReporter);
    }

    public int sizeFeatures() {
        return this.namedFeatureStore.size();
    }

    @Override
    public FeatureNameList createFeatureNames() {
        return this.namedFeatureStore.featureNames();
    }

    @Generated
    public SingleTableCalculator(NamedFeatureStore<FeatureInputSingleObject> namedFeatureStore) {
        this.namedFeatureStore = namedFeatureStore;
    }
}

