/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.feature.calculator.merged;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorMulti;
import org.anchoranalysis.feature.calculate.bound.FeatureCalculatorMultiChangeInput;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.feature.initialization.FeatureInitialization;
import org.anchoranalysis.feature.input.FeatureInputEnergy;
import org.anchoranalysis.feature.session.FeatureSession;
import org.anchoranalysis.feature.session.cache.finder.CacheTransferSourceCollection;
import org.anchoranalysis.feature.session.cache.finder.CheckCacheForSpecificChildren;
import org.anchoranalysis.feature.session.cache.finder.ChildCacheFinder;
import org.anchoranalysis.feature.session.calculator.FeatureCalculatorCache;
import org.anchoranalysis.feature.session.replace.BoundReplaceStrategy;
import org.anchoranalysis.feature.session.replace.ReplaceStrategy;
import org.anchoranalysis.feature.session.replace.ReuseSingletonStrategy;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.feature.calculator.InitializationFactory;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;

class CreateCalculatorHelper {
    private final Optional<EnergyStack> energyStack;
    private final Logger logger;

    public <T extends FeatureInputEnergy> FeatureCalculatorMulti<T> createCached(FeatureList<T> features, ImageInitialization initialization, BoundReplaceStrategy<T, ? extends ReplaceStrategy<T>> replacePolicyFactory) throws InitializeException {
        return this.wrapWithEnergy(FeatureCalculatorCache.cache(this.createWithoutEnergy(features, initialization, replacePolicyFactory)));
    }

    public <T extends FeatureInputEnergy> FeatureCalculatorMulti<T> createPair(FeatureList<T> features, ImageInitialization initialization, CacheTransferSourceCollection cacheTransferSource) throws InitializeException {
        BoundReplaceStrategy replaceStrategy = new BoundReplaceStrategy(cacheCreator -> new ReuseSingletonStrategy(cacheCreator, (ChildCacheFinder)new CheckCacheForSpecificChildren(FeatureInputSingleObject.class, cacheTransferSource)));
        return this.wrapWithEnergy(this.createWithoutEnergy(features, initialization, replaceStrategy));
    }

    private <T extends FeatureInputEnergy> FeatureCalculatorMulti<T> createWithoutEnergy(FeatureList<T> features, ImageInitialization initialization, BoundReplaceStrategy<T, ? extends ReplaceStrategy<T>> replacePolicyFactory) throws InitializeException {
        return FeatureSession.with(features, (FeatureInitialization)this.createInitialization(initialization), Optional.empty(), (Logger)this.logger, replacePolicyFactory);
    }

    private <T extends FeatureInputEnergy> FeatureCalculatorMulti<T> wrapWithEnergy(FeatureCalculatorMulti<T> calculator) {
        return new FeatureCalculatorMultiChangeInput(calculator, input -> input.setEnergyStack(this.energyStack));
    }

    private FeatureInitialization createInitialization(ImageInitialization initialization) {
        return InitializationFactory.create(Optional.of(initialization.sharedObjects()), this.energyStack);
    }

    @Generated
    public CreateCalculatorHelper(Optional<EnergyStack> energyStack, Logger logger) {
        this.energyStack = energyStack;
        this.logger = logger;
    }
}

