/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.feature.calculator.merged;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.log.error.ErrorReporter;
import org.anchoranalysis.feature.bean.Feature;
import org.anchoranalysis.feature.bean.list.FeatureList;
import org.anchoranalysis.feature.calculate.NamedFeatureCalculateException;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.feature.name.FeatureNameList;
import org.anchoranalysis.feature.results.ResultsVector;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.feature.calculator.FeatureTableCalculator;
import org.anchoranalysis.image.feature.calculator.merged.CombinedCalculator;
import org.anchoranalysis.image.feature.calculator.merged.CreateCalculatorHelper;
import org.anchoranalysis.image.feature.calculator.merged.MergedPairsFeatures;
import org.anchoranalysis.image.feature.calculator.merged.MergedPairsInclude;
import org.anchoranalysis.image.feature.input.FeatureInputPairObjects;

public class PairsTableCalculator
implements FeatureTableCalculator<FeatureInputPairObjects> {
    private final MergedPairsFeatures features;
    private final MergedPairsInclude include;
    private final boolean suppressErrors;
    private CombinedCalculator calculator;

    public PairsTableCalculator(MergedPairsFeatures features) {
        this(features, new MergedPairsInclude(), true);
    }

    @Override
    public void start(ImageInitialization initializtion, Optional<EnergyStack> energyStack, Logger logger) throws InitializeException {
        this.calculator = new CombinedCalculator(this.features, new CreateCalculatorHelper(energyStack, logger), this.include, initializtion);
    }

    public ResultsVector calculate(FeatureInputPairObjects input) throws NamedFeatureCalculateException {
        return this.calculator.calculateForInput(input, Optional.empty());
    }

    public ResultsVector calculate(FeatureInputPairObjects input, FeatureList<FeatureInputPairObjects> featuresSubset) {
        throw new UnsupportedOperationException();
    }

    public ResultsVector calculateSuppressErrors(FeatureInputPairObjects input, ErrorReporter errorReporter) {
        try {
            return this.calculator.calculateForInput(input, Optional.of(errorReporter));
        }
        catch (NamedFeatureCalculateException e) {
            errorReporter.recordError(PairsTableCalculator.class, (Throwable)e);
            ResultsVector results = new ResultsVector(this.sizeFeatures());
            results.setErrorAll((Exception)((Object)e));
            return results;
        }
    }

    public ResultsVector calculateMaybeSuppressErrors(FeatureInputPairObjects input, ErrorReporter errorReporter) throws NamedFeatureCalculateException {
        if (this.suppressErrors) {
            return this.calculateSuppressErrors(input, errorReporter);
        }
        return this.calculate(input);
    }

    @Override
    public FeatureNameList createFeatureNames() {
        FeatureNameList out = new FeatureNameList();
        PairsTableCalculator.addCustomNamesWithPrefix("image.", this.features.getImage(), out);
        if (this.include.includeFirst()) {
            PairsTableCalculator.addCustomNamesWithPrefix("first.", this.features.getSingle(), out);
        }
        if (this.include.includeSecond()) {
            PairsTableCalculator.addCustomNamesWithPrefix("second.", this.features.getSingle(), out);
        }
        if (this.include.includeMerged()) {
            PairsTableCalculator.addCustomNamesWithPrefix("merged.", this.features.getSingle(), out);
        }
        PairsTableCalculator.addCustomNamesWithPrefix("pair.", this.features.getPair(), out);
        return out;
    }

    public int sizeFeatures() {
        return this.calculator.sizeFeatures();
    }

    @Override
    public FeatureTableCalculator<FeatureInputPairObjects> duplicateForNewThread() {
        return new PairsTableCalculator(this.features.duplicate(), this.include, this.suppressErrors);
    }

    private static void addCustomNamesWithPrefix(String prefix, FeatureList<?> featuresWithCustomNames, FeatureNameList list) {
        for (Feature feature : featuresWithCustomNames) {
            list.add(prefix + feature.getCustomName());
        }
    }

    @Generated
    public PairsTableCalculator(MergedPairsFeatures features, MergedPairsInclude include, boolean suppressErrors) {
        this.features = features;
        this.include = include;
        this.suppressErrors = suppressErrors;
    }
}

