/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.feature.input;

import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.feature.energy.EnergyStack;
import org.anchoranalysis.feature.input.FeatureInputEnergy;
import org.anchoranalysis.image.core.merge.ObjectMaskMerger;
import org.anchoranalysis.image.voxel.object.ObjectMask;

public class FeatureInputPairObjects
extends FeatureInputEnergy {
    private ObjectMask first;
    private ObjectMask second;
    private Optional<ObjectMask> merged = Optional.empty();

    public FeatureInputPairObjects(ObjectMask first, ObjectMask second) {
        this(first, second, Optional.empty());
    }

    public FeatureInputPairObjects(ObjectMask first, ObjectMask second, EnergyStack energyStack) {
        this(first, second, Optional.of(energyStack));
    }

    public FeatureInputPairObjects(ObjectMask first, ObjectMask second, Optional<EnergyStack> energyStack) {
        this(first, second, energyStack, Optional.empty());
    }

    public FeatureInputPairObjects(ObjectMask first, ObjectMask second, Optional<EnergyStack> energyStack, Optional<ObjectMask> merged) {
        super(energyStack);
        this.first = first;
        this.second = second;
        this.merged = merged;
    }

    protected FeatureInputPairObjects(FeatureInputPairObjects src) {
        super(src.getEnergyStackOptional());
        this.first = src.first;
        this.second = src.second;
        this.merged = src.merged;
    }

    public ObjectMask getFirst() {
        return this.first;
    }

    public ObjectMask getSecond() {
        return this.second;
    }

    public ObjectMask getMerged() {
        if (!this.merged.isPresent()) {
            this.merged = Optional.of(ObjectMaskMerger.merge((ObjectMask)this.first, (ObjectMask)this.second));
        }
        return this.merged.get();
    }

    public Optional<ObjectMask> getMergedOptional() {
        return this.merged;
    }

    public String toString() {
        return String.format("%s vs %s", this.first.centerOfGravity(), this.second.centerOfGravity());
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof FeatureInputPairObjects)) {
            return false;
        }
        FeatureInputPairObjects other = (FeatureInputPairObjects)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        ObjectMask this$first = this.getFirst();
        ObjectMask other$first = other.getFirst();
        if (this$first == null ? other$first != null : !this$first.equals(other$first)) {
            return false;
        }
        ObjectMask this$second = this.getSecond();
        ObjectMask other$second = other.getSecond();
        if (this$second == null ? other$second != null : !this$second.equals(other$second)) {
            return false;
        }
        ObjectMask this$merged = this.getMerged();
        ObjectMask other$merged = other.getMerged();
        return !(this$merged == null ? other$merged != null : !this$merged.equals(other$merged));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof FeatureInputPairObjects;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        ObjectMask $first = this.getFirst();
        result = result * 59 + ($first == null ? 43 : $first.hashCode());
        ObjectMask $second = this.getSecond();
        result = result * 59 + ($second == null ? 43 : $second.hashCode());
        ObjectMask $merged = this.getMerged();
        result = result * 59 + ($merged == null ? 43 : $merged.hashCode());
        return result;
    }
}

