/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.inference;

import java.util.List;
import java.util.Optional;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.inference.segment.DualScale;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public final class ImageInferenceContext {
    private final DualScale<Dimensions> dimensions;
    private final ScaleFactor scaleFactor;
    private final Optional<List<String>> classLabels;
    private final VoxelsResizer resizer;
    private final ExecutionTimeRecorder executionTimeRecorder;
    private final Logger logger;

    public final DualScale<Optional<ScaleFactor>> scaleFactorUpscale() {
        return new DualScale<Optional<ScaleFactor>>(Optional.of(this.scaleFactor), Optional.empty());
    }

    public ImageInferenceContext(DualScale<Dimensions> dimensions, ScaleFactor scaleFactor, Optional<List<String>> classLabels, VoxelsResizer resizer, ExecutionTimeRecorder executionTimeRecorder, Logger logger) {
        this.dimensions = dimensions;
        this.scaleFactor = scaleFactor;
        this.classLabels = classLabels;
        this.resizer = resizer;
        this.executionTimeRecorder = executionTimeRecorder;
        this.logger = logger;
    }

    public DualScale<Dimensions> getDimensions() {
        return this.dimensions;
    }

    public ScaleFactor getScaleFactor() {
        return this.scaleFactor;
    }

    public Optional<List<String>> getClassLabels() {
        return this.classLabels;
    }

    public VoxelsResizer getResizer() {
        return this.resizer;
    }

    public ExecutionTimeRecorder getExecutionTimeRecorder() {
        return this.executionTimeRecorder;
    }

    public Logger getLogger() {
        return this.logger;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ImageInferenceContext)) {
            return false;
        }
        ImageInferenceContext other = (ImageInferenceContext)o;
        DualScale<Dimensions> this$dimensions = this.getDimensions();
        DualScale<Dimensions> other$dimensions = other.getDimensions();
        if (this$dimensions == null ? other$dimensions != null : !this$dimensions.equals(other$dimensions)) {
            return false;
        }
        ScaleFactor this$scaleFactor = this.getScaleFactor();
        ScaleFactor other$scaleFactor = other.getScaleFactor();
        if (this$scaleFactor == null ? other$scaleFactor != null : !this$scaleFactor.equals(other$scaleFactor)) {
            return false;
        }
        Optional<List<String>> this$classLabels = this.getClassLabels();
        Optional<List<String>> other$classLabels = other.getClassLabels();
        if (this$classLabels == null ? other$classLabels != null : !((Object)this$classLabels).equals(other$classLabels)) {
            return false;
        }
        VoxelsResizer this$resizer = this.getResizer();
        VoxelsResizer other$resizer = other.getResizer();
        if (this$resizer == null ? other$resizer != null : !this$resizer.equals(other$resizer)) {
            return false;
        }
        ExecutionTimeRecorder this$executionTimeRecorder = this.getExecutionTimeRecorder();
        ExecutionTimeRecorder other$executionTimeRecorder = other.getExecutionTimeRecorder();
        if (this$executionTimeRecorder == null ? other$executionTimeRecorder != null : !this$executionTimeRecorder.equals(other$executionTimeRecorder)) {
            return false;
        }
        Logger this$logger = this.getLogger();
        Logger other$logger = other.getLogger();
        return !(this$logger == null ? other$logger != null : !this$logger.equals(other$logger));
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        DualScale<Dimensions> $dimensions = this.getDimensions();
        result = result * 59 + ($dimensions == null ? 43 : $dimensions.hashCode());
        ScaleFactor $scaleFactor = this.getScaleFactor();
        result = result * 59 + ($scaleFactor == null ? 43 : $scaleFactor.hashCode());
        Optional<List<String>> $classLabels = this.getClassLabels();
        result = result * 59 + ($classLabels == null ? 43 : ((Object)$classLabels).hashCode());
        VoxelsResizer $resizer = this.getResizer();
        result = result * 59 + ($resizer == null ? 43 : $resizer.hashCode());
        ExecutionTimeRecorder $executionTimeRecorder = this.getExecutionTimeRecorder();
        result = result * 59 + ($executionTimeRecorder == null ? 43 : $executionTimeRecorder.hashCode());
        Logger $logger = this.getLogger();
        result = result * 59 + ($logger == null ? 43 : $logger.hashCode());
        return result;
    }

    public String toString() {
        return "ImageInferenceContext(dimensions=" + this.getDimensions() + ", scaleFactor=" + this.getScaleFactor() + ", classLabels=" + this.getClassLabels() + ", resizer=" + this.getResizer() + ", executionTimeRecorder=" + this.getExecutionTimeRecorder() + ", logger=" + this.getLogger() + ")";
    }
}

