/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.inference.bean.reduce;

import java.util.List;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.inference.bean.reduce.ObjectForReduction;
import org.anchoranalysis.image.inference.bean.reduce.ReduceObjectsGraph;
import org.anchoranalysis.image.inference.bean.segment.reduce.ReduceElements;
import org.anchoranalysis.image.inference.segment.LabelledWithConfidence;
import org.anchoranalysis.image.inference.segment.ReductionOutcome;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.Extent;

public abstract class ReduceElementsGreedy
extends ReduceElements<ObjectMask> {
    @Override
    public ReductionOutcome<LabelledWithConfidence<ObjectMask>> reduce(List<LabelledWithConfidence<ObjectMask>> elements, Extent extent, ExecutionTimeRecorder executionTimeRecorder) {
        ReduceObjectsGraph graph = new ReduceObjectsGraph(elements);
        ReductionOutcome<LabelledWithConfidence<ObjectMask>> outcome = new ReductionOutcome<LabelledWithConfidence<ObjectMask>>();
        while (!graph.isEmpty()) {
            ObjectForReduction highestConfidence = graph.peek();
            if (this.findIntersectionsAndProcess(highestConfidence, graph)) continue;
            ReduceElementsGreedy.addVertexToOutcome(graph.poll(), outcome);
        }
        return outcome;
    }

    protected abstract boolean shouldObjectsBeProcessed(ObjectMask var1, ObjectMask var2);

    protected abstract boolean processObjects(ObjectForReduction var1, ObjectForReduction var2, ReduceObjectsGraph var3);

    private boolean findIntersectionsAndProcess(ObjectForReduction proposal, ReduceObjectsGraph graph) {
        List<ObjectForReduction> intersecting = graph.adjacentVerticesOutgoing(proposal);
        for (ObjectForReduction other : intersecting) {
            if (!this.shouldObjectsBeProcessed(proposal.getElement(), other.getElement()) || !this.processObjects(proposal, other, graph)) continue;
            return true;
        }
        return false;
    }

    private static void addVertexToOutcome(ObjectForReduction vertex, ReductionOutcome<LabelledWithConfidence<ObjectMask>> outcome) {
        if (vertex.getIndex() == -1) {
            outcome.addNewlyAdded(vertex.getLabelled());
        } else {
            outcome.addIndexToRetain(vertex.getIndex());
        }
    }
}

