/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.inference.bean.segment.instance;

import java.nio.file.Path;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.bean.nonbean.segment.SegmentationFailedException;
import org.anchoranalysis.image.bean.segment.SegmentationBean;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.inference.segment.SegmentedObjects;
import org.anchoranalysis.inference.InferenceModel;
import org.anchoranalysis.inference.concurrency.ConcurrencyPlan;
import org.anchoranalysis.inference.concurrency.ConcurrentModelPool;
import org.anchoranalysis.inference.concurrency.CreateModelFailedException;

public abstract class SegmentStackIntoObjectsPooled<T extends InferenceModel>
extends SegmentationBean<SegmentStackIntoObjectsPooled<T>> {
    public SegmentedObjects segment(Stack stack, ExecutionTimeRecorder executionTimeRecorder) throws SegmentationFailedException {
        try {
            return this.segment(stack, this.createModelPool(ConcurrencyPlan.singleCPUProcessor((int)0), this.getLogger()), executionTimeRecorder);
        }
        catch (CreateModelFailedException e) {
            throw new SegmentationFailedException("Cannot create model for segmentaiton", (Throwable)e);
        }
    }

    public abstract ConcurrentModelPool<T> createModelPool(ConcurrencyPlan var1, Logger var2) throws CreateModelFailedException;

    public abstract SegmentedObjects segment(Stack var1, ConcurrentModelPool<T> var2, ExecutionTimeRecorder var3) throws SegmentationFailedException;

    protected Path resolve(String modelFilename) throws InitializeException {
        return ((ImageInitialization)this.getInitialization()).modelDirectory().resolve(modelFilename);
    }
}

