/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.inference.bean.segment.instance;

import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.exception.friendly.AnchorImpossibleSituationException;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.bean.nonbean.segment.SegmentationFailedException;
import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.dimensions.IncorrectImageSizeException;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.inference.segment.DualScale;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizerExecutionTime;
import org.anchoranalysis.spatial.scale.ScaleFactor;

class StackScaler {
    public static DualScale<Stack> scaleToModelSize(Stack stack, ScaleFactor scaleFactor, VoxelsResizer resizer, ExecutionTimeRecorder executionTimeRecorder) throws SegmentationFailedException {
        StackScaler.checkInput(stack);
        VoxelsResizerExecutionTime resizerRecording = new VoxelsResizerExecutionTime(resizer, executionTimeRecorder, "As model input");
        if (stack.getNumberChannels() == 1) {
            Channel channelScaled = StackScaler.scaleChannel(stack.getChannel(0), scaleFactor, (VoxelsResizer)resizerRecording);
            return new DualScale<Stack>(stack, StackScaler.grayscaleToRGB(channelScaled));
        }
        try {
            Stack stackScaled = stack.mapChannel(arg_0 -> StackScaler.lambda$scaleToModelSize$0(scaleFactor, (VoxelsResizer)resizerRecording, arg_0));
            return new DualScale<Stack>(stack, stackScaled);
        }
        catch (OperationFailedException e) {
            throw new SegmentationFailedException((Throwable)e);
        }
    }

    private static Channel scaleChannel(Channel channel, ScaleFactor scaleFactor, VoxelsResizer resizer) {
        return channel.scaleXY(scaleFactor, resizer);
    }

    private static Stack checkInput(Stack stack) throws SegmentationFailedException {
        if (stack.getNumberChannels() != 3 && stack.getNumberChannels() != 1) {
            throw new SegmentationFailedException(String.format("Only RGB (3 channels) and grayscale (1 channel) stacks are supported by this algorithm. This stack has %d channels.", stack.getNumberChannels()));
        }
        if (stack.dimensions().z() > 1) {
            throw new SegmentationFailedException("z-stacks are not supported by this algorithm");
        }
        return stack;
    }

    private static Stack grayscaleToRGB(Channel channel) {
        try {
            return new Stack(true, new Channel[]{channel, channel.duplicate(), channel.duplicate()});
        }
        catch (CreateException | IncorrectImageSizeException e) {
            throw new AnchorImpossibleSituationException();
        }
    }

    private StackScaler() {
    }

    private static /* synthetic */ Channel lambda$scaleToModelSize$0(ScaleFactor scaleFactor, VoxelsResizer resizerRecording, Channel channel) throws OperationFailedException {
        return StackScaler.scaleChannel(channel, scaleFactor, resizerRecording);
    }
}

