/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.inference.bean.segment.instance;

import java.io.BufferedReader;
import java.io.FileNotFoundException;
import java.io.FileReader;
import java.io.IOException;
import java.nio.file.Path;
import java.util.ArrayList;
import java.util.List;

class TextFileReader {
    public static String readFileAsString(Path path) throws IOException {
        StringBuilder stringBuilder = new StringBuilder();
        try (BufferedReader reader = TextFileReader.createReader(path);){
            String line = null;
            while ((line = reader.readLine()) != null) {
                stringBuilder.append(line);
                stringBuilder.append(System.lineSeparator());
            }
        }
        return stringBuilder.toString();
    }

    public static List<String> readLinesAsList(Path path) throws IOException {
        ArrayList<String> list = new ArrayList<String>();
        try (BufferedReader reader = TextFileReader.createReader(path);){
            String line;
            while ((line = reader.readLine()) != null) {
                list.add(line);
            }
        }
        return list;
    }

    private static BufferedReader createReader(Path path) throws FileNotFoundException {
        return new BufferedReader(new FileReader(path.toFile()));
    }

    private TextFileReader() {
    }
}

