/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.inference.bean.segment.instance;

import java.io.IOException;
import java.nio.file.Path;
import java.util.Iterator;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.bean.annotation.AllowEmpty;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.DefaultInstance;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.bean.primitive.DoubleList;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.bean.displayer.StackDisplayer;
import org.anchoranalysis.image.bean.interpolator.Interpolator;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.bean.nonbean.segment.SegmentationFailedException;
import org.anchoranalysis.image.bean.spatial.ScaleCalculator;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.inference.ImageInferenceContext;
import org.anchoranalysis.image.inference.ImageInferenceModel;
import org.anchoranalysis.image.inference.bean.segment.instance.DecodeInstanceSegmentation;
import org.anchoranalysis.image.inference.bean.segment.instance.InferenceHelper;
import org.anchoranalysis.image.inference.bean.segment.instance.SegmentStackIntoObjectsPooled;
import org.anchoranalysis.image.inference.bean.segment.instance.StackScaler;
import org.anchoranalysis.image.inference.bean.segment.instance.TextFileReader;
import org.anchoranalysis.image.inference.segment.DualScale;
import org.anchoranalysis.image.inference.segment.LabelledWithConfidence;
import org.anchoranalysis.image.inference.segment.MultiScaleObject;
import org.anchoranalysis.image.inference.segment.SegmentedBackground;
import org.anchoranalysis.image.inference.segment.SegmentedObjects;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizerExecutionTime;
import org.anchoranalysis.inference.concurrency.ConcurrentModelPool;
import org.anchoranalysis.spatial.scale.ScaleFactor;
import org.apache.commons.collections.IteratorUtils;

public abstract class SegmentStackIntoObjectsScaleDecode<T, S extends ImageInferenceModel<T>>
extends SegmentStackIntoObjectsPooled<S> {
    private static final String FALLBACK_INPUT_NAME = "no_name_defined";
    @BeanField
    private ScaleCalculator scaleInput;
    @BeanField
    private DecodeInstanceSegmentation<T> decode;
    @BeanField
    @OptionalBean
    private DoubleList subtractMean;
    @BeanField
    @AllowEmpty
    private String classLabelsPath = "";
    @BeanField
    @DefaultInstance
    private Interpolator interpolator;
    @BeanField
    @DefaultInstance
    private StackDisplayer displayer;

    @Override
    public SegmentedObjects segment(Stack stack, ConcurrentModelPool<S> modelPool, ExecutionTimeRecorder executionTimeRecorder) throws SegmentationFailedException {
        try {
            ScaleFactor scaleFactor = this.scaleInput.calculate(Optional.of(stack.dimensions()), Optional.empty());
            DualScale stacksDual = (DualScale)executionTimeRecorder.recordExecutionTime("Scaling stack to model-size", () -> StackScaler.scaleToModelSize(stack, scaleFactor, this.interpolator.voxelsResizer(), executionTimeRecorder));
            Object input = executionTimeRecorder.recordExecutionTime("Deriving input for segmentation", () -> this.deriveInputSubtractMeans((Stack)stacksDual.atModelScale()));
            return this.segmentInput(input, new SegmentedBackground(stacksDual, this.displayer), scaleFactor, modelPool, executionTimeRecorder);
        }
        catch (OperationFailedException e) {
            throw new SegmentationFailedException((Throwable)e);
        }
    }

    private SegmentedObjects segmentInput(T input, SegmentedBackground background, ScaleFactor scaleFactor, ConcurrentModelPool<S> modelPool, ExecutionTimeRecorder executionTimeRecorder) throws SegmentationFailedException {
        try {
            ImageInferenceContext context = this.createContext(background.getBackground(), scaleFactor, executionTimeRecorder);
            String inputName = this.inputName().orElse(FALLBACK_INPUT_NAME);
            InferenceHelper<T, S> helper = new InferenceHelper<T, S>(this.decode, inputName);
            List<LabelledWithConfidence<MultiScaleObject>> objects = helper.queueInference(input, modelPool, context);
            return new SegmentedObjects(objects, background, executionTimeRecorder);
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            throw new SegmentationFailedException((Throwable)e);
        }
        catch (Throwable e) {
            throw new SegmentationFailedException(e);
        }
    }

    protected abstract T deriveInput(Stack var1, Optional<double[]> var2) throws OperationFailedException;

    protected abstract Optional<String> inputName();

    private Optional<double[]> subtractMeanArray(int numberChannels) throws OperationFailedException {
        if (this.subtractMean != null) {
            List list = IteratorUtils.toList((Iterator)this.subtractMean.iterator());
            if (list.size() != numberChannels) {
                throw new OperationFailedException(String.format("There are %d channels in the input stack for inference, but %d constants were supplied for mean-subtraction.", numberChannels, list.size()));
            }
            double[] array = list.stream().mapToDouble(Double::doubleValue).toArray();
            return Optional.of(array);
        }
        return Optional.empty();
    }

    private Optional<List<String>> classLabels() throws IOException {
        if (!this.classLabelsPath.isEmpty()) {
            try {
                Path filename = this.resolve(this.classLabelsPath);
                return Optional.of(TextFileReader.readLinesAsList(filename));
            }
            catch (InitializeException e) {
                throw new IOException(e);
            }
        }
        return Optional.empty();
    }

    private ImageInferenceContext createContext(DualScale<Stack> stacks, ScaleFactor scaleFactor, ExecutionTimeRecorder executionTimeRecorder) throws InitializeException, IOException {
        return new ImageInferenceContext(stacks.map(Stack::dimensions), scaleFactor.invert(), this.classLabels(), (VoxelsResizer)new VoxelsResizerExecutionTime(this.interpolator.voxelsResizer(), executionTimeRecorder, "Resizing during inference"), executionTimeRecorder, ((ImageInitialization)this.getInitialization()).sharedObjects().getContext().getLogger());
    }

    private T deriveInputSubtractMeans(Stack stack) throws OperationFailedException {
        Optional<double[]> subtractMeans = this.subtractMeanArray(stack.getNumberChannels());
        return this.deriveInput(stack, subtractMeans);
    }

    @Generated
    public ScaleCalculator getScaleInput() {
        return this.scaleInput;
    }

    @Generated
    public void setScaleInput(ScaleCalculator scaleInput) {
        this.scaleInput = scaleInput;
    }

    @Generated
    public DecodeInstanceSegmentation<T> getDecode() {
        return this.decode;
    }

    @Generated
    public void setDecode(DecodeInstanceSegmentation<T> decode) {
        this.decode = decode;
    }

    @Generated
    public DoubleList getSubtractMean() {
        return this.subtractMean;
    }

    @Generated
    public void setSubtractMean(DoubleList subtractMean) {
        this.subtractMean = subtractMean;
    }

    @Generated
    public String getClassLabelsPath() {
        return this.classLabelsPath;
    }

    @Generated
    public void setClassLabelsPath(String classLabelsPath) {
        this.classLabelsPath = classLabelsPath;
    }

    @Generated
    public Interpolator getInterpolator() {
        return this.interpolator;
    }

    @Generated
    public void setInterpolator(Interpolator interpolator) {
        this.interpolator = interpolator;
    }

    @Generated
    public StackDisplayer getDisplayer() {
        return this.displayer;
    }

    @Generated
    public void setDisplayer(StackDisplayer displayer) {
        this.displayer = displayer;
    }
}

