/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.inference.segment;

import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.anchoranalysis.core.functional.FunctionalList;

public class ReductionOutcome<T> {
    private final List<Integer> indicesRetained;
    private List<T> added = new ArrayList<T>();

    public ReductionOutcome() {
        this.indicesRetained = new ArrayList<Integer>();
    }

    public void addIndexToRetain(int index) {
        this.indicesRetained.add(index);
    }

    public void addNewlyAdded(T toAdd) {
        this.added.add(toAdd);
    }

    public List<T> listAfter(List<T> input) {
        ArrayList<T> out = new ArrayList<T>(this.indicesRetained.size());
        for (int index : this.indicesRetained) {
            out.add(input.get(index));
        }
        out.addAll(this.added);
        return out;
    }

    public int sizeAfter() {
        return this.added.size() + this.indicesRetained.size();
    }

    public <S> ReductionOutcome<S> map(UnaryOperator<Integer> mapIndex, Function<T, S> mapAdded) {
        List indicesMapped = FunctionalList.mapToList(this.indicesRetained, mapIndex);
        List addedMapped = FunctionalList.mapToList(this.added, mapAdded);
        return new ReductionOutcome<T>(indicesMapped, addedMapped);
    }

    @Generated
    public ReductionOutcome(List<Integer> indicesRetained) {
        this.indicesRetained = indicesRetained;
    }

    @Generated
    public ReductionOutcome(List<Integer> indicesRetained, List<T> added) {
        this.indicesRetained = indicesRetained;
        this.added = added;
    }
}

