/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.inference.segment;

import java.util.Collection;
import java.util.List;
import java.util.Optional;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.inference.bean.segment.reduce.ReduceElements;
import org.anchoranalysis.image.inference.segment.DualScale;
import org.anchoranalysis.image.inference.segment.LabelledWithConfidence;
import org.anchoranalysis.image.inference.segment.MultiScaleObject;
import org.anchoranalysis.image.inference.segment.SegmentedBackground;
import org.anchoranalysis.image.inference.segment.SegmentedObjectsAtScale;
import org.anchoranalysis.image.inference.segment.SegmentedObjectsReducer;
import org.anchoranalysis.image.inference.segment.WithConfidence;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.scale.RelativeScaleCalculator;
import org.anchoranalysis.spatial.scale.ScaleFactor;

public class SegmentedObjects {
    private final List<LabelledWithConfidence<MultiScaleObject>> list;
    private final DualScale<SegmentedObjectsAtScale> objects;
    private final SegmentedBackground background;

    public SegmentedObjects(String classLabel, Collection<WithConfidence<MultiScaleObject>> objects, SegmentedBackground background, ExecutionTimeRecorder executionTimeRecorder) {
        this(SegmentedObjects.addLabel(classLabel, objects), background, executionTimeRecorder);
    }

    public SegmentedObjects(List<LabelledWithConfidence<MultiScaleObject>> objects, SegmentedBackground background, ExecutionTimeRecorder executionTimeRecorder) {
        this.list = objects;
        this.background = background;
        this.objects = new DualScale<SegmentedObjectsAtScale>(new SegmentedObjectsAtScale(this.list, MultiScaleObject::getInputScale, background.atInputScale(), background.getDisplayer(), executionTimeRecorder, " (input-scale)"), new SegmentedObjectsAtScale(this.list, MultiScaleObject::getModelScale, background.atModelScale(), background.getDisplayer(), executionTimeRecorder, " (model-scale)"));
    }

    public SegmentedObjects reduce(ReduceElements<ObjectMask> reduce, boolean separateEachLabel, ExecutionTimeRecorder executionTimeRecorder) throws OperationFailedException {
        DualScale<Extent> extent = this.objects.map(SegmentedObjectsAtScale::extent);
        ScaleFactor scaleFactor = extent.apply((input, model) -> RelativeScaleCalculator.relativeScale((Extent)model, (Extent)input, (boolean)false));
        SegmentedObjectsReducer reducer = new SegmentedObjectsReducer(this.list, this.objects.atModelScale().listWithLabels(), this.objects.atModelScale().extent(), reduce, this.background, executionTimeRecorder, element -> new MultiScaleObject(() -> element.scale(scaleFactor, Optional.of((Extent)extent.atInputScale())), () -> element));
        return reducer.reduce(separateEachLabel);
    }

    public Optional<WithConfidence<MultiScaleObject>> highestConfidence() {
        return this.list.stream().map(LabelledWithConfidence::getWithConfidence).max((a, b) -> Double.compare(a.getConfidence(), b.getConfidence()));
    }

    public int size() {
        return this.list.size();
    }

    public boolean isEmpty() {
        return this.list.isEmpty();
    }

    private static List<LabelledWithConfidence<MultiScaleObject>> addLabel(String label, Collection<WithConfidence<MultiScaleObject>> objects) {
        return FunctionalList.mapToList(objects.stream(), withConfidence -> new LabelledWithConfidence(label, withConfidence));
    }

    @Generated
    public DualScale<SegmentedObjectsAtScale> getObjects() {
        return this.objects;
    }
}

