/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.inference.segment;

import com.google.common.collect.ListMultimap;
import com.google.common.collect.Multimap;
import com.google.common.collect.MultimapBuilder;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import lombok.Generated;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.core.time.ExecutionTimeRecorder;
import org.anchoranalysis.image.inference.bean.reduce.ObjectForReduction;
import org.anchoranalysis.image.inference.bean.reduce.ObjectForReductionFactory;
import org.anchoranalysis.image.inference.bean.segment.reduce.ReduceElements;
import org.anchoranalysis.image.inference.segment.LabelledWithConfidence;
import org.anchoranalysis.image.inference.segment.MultiScaleObject;
import org.anchoranalysis.image.inference.segment.ReductionOutcome;
import org.anchoranalysis.image.inference.segment.SegmentedBackground;
import org.anchoranalysis.image.inference.segment.SegmentedObjects;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.Extent;

class SegmentedObjectsReducer {
    private final List<LabelledWithConfidence<MultiScaleObject>> list;
    private final List<LabelledWithConfidence<ObjectMask>> objects;
    private final Extent extent;
    private final ReduceElements<ObjectMask> reduce;
    private final SegmentedBackground background;
    private final ExecutionTimeRecorder executionTimeRecorder;
    private final Function<ObjectMask, MultiScaleObject> convertToScale;

    public SegmentedObjects reduce(boolean separateEachLabel) throws OperationFailedException {
        if (separateEachLabel) {
            return new SegmentedObjects(this.reducedObjectsSeparate(), this.background, this.executionTimeRecorder);
        }
        return new SegmentedObjects(this.reduceList(this.objects, this.extent, index -> index), this.background, this.executionTimeRecorder);
    }

    private List<LabelledWithConfidence<MultiScaleObject>> reducedObjectsSeparate() throws OperationFailedException {
        ArrayList<LabelledWithConfidence<MultiScaleObject>> out = new ArrayList<LabelledWithConfidence<MultiScaleObject>>();
        Multimap<String, ObjectForReduction> map = this.createObjectMap();
        for (String label : map.keySet()) {
            ArrayList forReduction = new ArrayList(map.get((Object)label));
            List listForReduction = FunctionalList.mapToList(forReduction.stream(), ObjectForReduction::getLabelled);
            out.addAll(this.reduceList(listForReduction, this.extent, index -> ((ObjectForReduction)forReduction.get((int)index)).getIndex()));
        }
        return out;
    }

    private Multimap<String, ObjectForReduction> createObjectMap() {
        ListMultimap map = MultimapBuilder.treeKeys().arrayListValues().build();
        ObjectForReductionFactory.populateFromList(this.objects).forEach(arg_0 -> SegmentedObjectsReducer.lambda$createObjectMap$0((Multimap)map, arg_0));
        return map;
    }

    private List<LabelledWithConfidence<MultiScaleObject>> reduceList(List<LabelledWithConfidence<ObjectMask>> elements, Extent extent, UnaryOperator<Integer> mapIndex) throws OperationFailedException {
        ReductionOutcome<LabelledWithConfidence<ObjectMask>> outcome = this.reduce.reduce(elements, extent, this.executionTimeRecorder);
        ReductionOutcome<LabelledWithConfidence> outcomeMapped = outcome.map(mapIndex, this::convertToMultiScale);
        return outcomeMapped.listAfter(this.list);
    }

    private LabelledWithConfidence<MultiScaleObject> convertToMultiScale(LabelledWithConfidence<ObjectMask> labelled) {
        return new LabelledWithConfidence<MultiScaleObject>(this.convertToScale.apply(labelled.getElement()), labelled.getConfidence(), labelled.getLabel());
    }

    @Generated
    public SegmentedObjectsReducer(List<LabelledWithConfidence<MultiScaleObject>> list, List<LabelledWithConfidence<ObjectMask>> objects, Extent extent, ReduceElements<ObjectMask> reduce, SegmentedBackground background, ExecutionTimeRecorder executionTimeRecorder, Function<ObjectMask, MultiScaleObject> convertToScale) {
        this.list = list;
        this.objects = objects;
        this.extent = extent;
        this.reduce = reduce;
        this.background = background;
        this.executionTimeRecorder = executionTimeRecorder;
        this.convertToScale = convertToScale;
    }

    private static /* synthetic */ void lambda$createObjectMap$0(Multimap map, ObjectForReduction object) {
        map.put((Object)object.getLabel(), (Object)object);
    }
}

