/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.bean.object.draw;

import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.core.exception.OperationFailedException;
import org.anchoranalysis.image.core.object.properties.ObjectWithProperties;
import org.anchoranalysis.image.core.stack.RGBStack;
import org.anchoranalysis.overlay.bean.DrawObject;
import org.anchoranalysis.overlay.writer.ObjectDrawAttributes;
import org.anchoranalysis.spatial.box.BoundingBox;

public class IfElse
extends DrawObject {
    @BeanField
    private DrawObject whenTrue;
    @BeanField
    private DrawObject whenFalse;
    private Optional<Predicate> predicate = Optional.empty();

    public IfElse(Predicate predicate, DrawObject whenTrue, DrawObject whenFalse) {
        this.predicate = Optional.of(predicate);
        this.whenTrue = whenTrue;
        this.whenFalse = whenFalse;
    }

    public void drawSingle(ObjectWithProperties object, RGBStack stack, ObjectDrawAttributes attributes, int iteration, BoundingBox restrictTo) throws OperationFailedException {
        if (this.predicate.isPresent() && this.predicate.get().test(object, stack, attributes.idFor(object, iteration))) {
            this.whenTrue.drawSingle(object, stack, attributes, iteration, restrictTo);
        } else {
            this.whenFalse.drawSingle(object, stack, attributes, iteration, restrictTo);
        }
    }

    public IfElse() {
    }

    public DrawObject getWhenTrue() {
        return this.whenTrue;
    }

    public void setWhenTrue(DrawObject whenTrue) {
        this.whenTrue = whenTrue;
    }

    public DrawObject getWhenFalse() {
        return this.whenFalse;
    }

    public void setWhenFalse(DrawObject whenFalse) {
        this.whenFalse = whenFalse;
    }

    @FunctionalInterface
    public static interface Predicate {
        public boolean test(ObjectWithProperties var1, RGBStack var2, int var3);
    }
}

