/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.bean.object.feature;

import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.xml.exception.ProvisionFailedException;
import org.anchoranalysis.core.exception.CreateException;
import org.anchoranalysis.core.exception.InitializeException;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.image.bean.ImageBean;
import org.anchoranalysis.image.bean.nonbean.init.ImageInitialization;
import org.anchoranalysis.image.bean.provider.ObjectCollectionProvider;
import org.anchoranalysis.image.feature.bean.evaluator.FeatureListEvaluator;
import org.anchoranalysis.image.feature.input.FeatureInputSingleObject;
import org.anchoranalysis.image.io.bean.object.feature.ObjectFeatureListCSVGenerator;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;
import org.anchoranalysis.io.output.outputter.InputOutputContext;

public class OutputFeatureTable
extends ImageBean<OutputFeatureTable> {
    public static final String OUTPUT_FEATURE_TABLE = "features";
    @BeanField
    private ObjectCollectionProvider objects;
    @BeanField
    private FeatureListEvaluator<FeatureInputSingleObject> feature;

    public void output(InputOutputContext context) {
        if (!context.getOutputter().outputsEnabled().isOutputEnabled(OUTPUT_FEATURE_TABLE)) {
            return;
        }
        context.getOutputter().writerSelective().write(OUTPUT_FEATURE_TABLE, () -> this.createGenerator(context.getLogger()), this::createObjectsWrapException);
    }

    private ObjectCollection createObjectsWrapException() throws OutputWriteFailedException {
        try {
            return (ObjectCollection)this.objects.get();
        }
        catch (ProvisionFailedException e) {
            throw new OutputWriteFailedException((Throwable)e);
        }
    }

    private ObjectFeatureListCSVGenerator createGenerator(Logger logger) throws OutputWriteFailedException {
        try {
            return new ObjectFeatureListCSVGenerator(this.feature, ((ImageInitialization)this.getInitialization()).sharedObjects(), logger);
        }
        catch (CreateException | InitializeException e) {
            throw new OutputWriteFailedException(e);
        }
    }

    public ObjectCollectionProvider getObjects() {
        return this.objects;
    }

    public void setObjects(ObjectCollectionProvider objects) {
        this.objects = objects;
    }

    public FeatureListEvaluator<FeatureInputSingleObject> getFeature() {
        return this.feature;
    }

    public void setFeature(FeatureListEvaluator<FeatureInputSingleObject> feature) {
        this.feature = feature;
    }
}

