/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.bean.stack.combine;

import java.util.List;
import org.anchoranalysis.core.functional.FunctionalList;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.image.bean.nonbean.spatial.arrange.ArrangeStackException;
import org.anchoranalysis.image.bean.spatial.arrange.StackArranger;
import org.anchoranalysis.image.core.stack.RGBStack;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.stack.output.StackWriteAttributes;
import org.anchoranalysis.image.io.stack.output.generator.RasterGenerator;
import org.anchoranalysis.image.io.stack.output.generator.RasterGeneratorSelectFormat;
import org.anchoranalysis.image.voxel.resizer.VoxelsResizer;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;

class CombineGenerator<T>
extends RasterGeneratorSelectFormat<T> {
    private final StackArranger arrangeRaster;
    private final List<RasterGenerator<T>> generators;
    private final VoxelsResizer resizer;
    private final OperationContext context;

    public Stack transform(T element) throws OutputWriteFailedException {
        List<RGBStack> generated = this.generateAll(element);
        try {
            return this.arrangeRaster.combine(generated, this.resizer, this.context).asStack();
        }
        catch (ArrangeStackException e) {
            throw new OutputWriteFailedException((Throwable)e);
        }
    }

    @Override
    public StackWriteAttributes guaranteedImageAttributes() {
        return this.generators.stream().map(RasterGenerator::guaranteedImageAttributes).reduce(StackWriteAttributes::and).get();
    }

    private List<RGBStack> generateAll(T element) throws OutputWriteFailedException {
        return FunctionalList.mapToList(this.generators, OutputWriteFailedException.class, generator -> new RGBStack((Stack)generator.transform(element)));
    }

    public CombineGenerator(StackArranger arrangeRaster, List<RasterGenerator<T>> generators, VoxelsResizer resizer, OperationContext context) {
        this.arrangeRaster = arrangeRaster;
        this.generators = generators;
        this.resizer = resizer;
        this.context = context;
    }
}

