/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.bean.stack.combine;

import java.awt.Color;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Rectangle;
import java.awt.image.BufferedImage;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.shared.color.RGBColorBean;
import org.anchoranalysis.core.color.RGBColor;
import org.anchoranalysis.spatial.box.Extent;

public class TextStyle
extends AnchorBean<TextStyle> {
    @BeanField
    private int fontSize = 12;
    @BeanField
    private String fontName = "SansSerif";
    @BeanField
    private RGBColorBean fontColor = new RGBColorBean(new RGBColor(Color.WHITE));
    @BeanField
    private boolean bold = false;

    public void drawText(String textToDraw, BufferedImage image, Extent extent) {
        Graphics2D graphics = this.createGraphicsFromBufferedImage(image);
        graphics.fill(new Rectangle(0, 0, extent.x(), extent.y()));
        TextStyle.drawCenteredString(textToDraw, extent, graphics);
    }

    private Graphics2D createGraphicsFromBufferedImage(BufferedImage bufferedImage) {
        Graphics2D graphics = bufferedImage.createGraphics();
        Font font = new Font(this.fontName, this.bold ? 1 : 0, this.fontSize);
        graphics.setColor(this.fontColor.toAWTColor());
        graphics.setFont(font);
        return graphics;
    }

    private static void drawCenteredString(String stringToDraw, Extent extent, Graphics graphics) {
        FontMetrics metrics = graphics.getFontMetrics();
        int x = (extent.x() - metrics.stringWidth(stringToDraw)) / 2;
        int y = metrics.getAscent() + (extent.y() - (metrics.getAscent() + metrics.getDescent())) / 2;
        graphics.drawString(stringToDraw, x, y);
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int fontSize) {
        this.fontSize = fontSize;
    }

    public String getFontName() {
        return this.fontName;
    }

    public void setFontName(String fontName) {
        this.fontName = fontName;
    }

    public RGBColorBean getFontColor() {
        return this.fontColor;
    }

    public void setFontColor(RGBColorBean fontColor) {
        this.fontColor = fontColor;
    }

    public boolean isBold() {
        return this.bold;
    }

    public void setBold(boolean bold) {
        this.bold = bold;
    }
}

