/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.bean.stack.metadata.reader;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.bean.annotation.BeanField;
import org.anchoranalysis.bean.annotation.OptionalBean;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.image.core.stack.ImageMetadata;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.bean.stack.metadata.reader.ImageMetadataReader;
import org.anchoranalysis.image.io.bean.stack.reader.StackReader;
import org.anchoranalysis.image.io.stack.input.OpenedImageFile;

public class FromStackReader
extends ImageMetadataReader {
    @BeanField
    @OptionalBean
    private StackReader stackReader;
    @BeanField
    private int seriesIndex = 0;

    public FromStackReader(StackReader stackReader) {
        this.stackReader = stackReader;
    }

    @Override
    public ImageMetadata openFile(Path path, StackReader defaultStackReader, OperationContext context) throws ImageIOException {
        StackReader selectedReader = Optional.ofNullable(this.stackReader).orElse(defaultStackReader);
        try (OpenedImageFile file = selectedReader.openFile(path, context.getExecutionTimeRecorder());){
            ImageMetadata imageMetadata = file.metadata(this.seriesIndex, context.getLogger());
            return imageMetadata;
        }
    }

    public FromStackReader() {
    }

    public StackReader getStackReader() {
        return this.stackReader;
    }

    public void setStackReader(StackReader stackReader) {
        this.stackReader = stackReader;
    }

    public int getSeriesIndex() {
        return this.seriesIndex;
    }

    public void setSeriesIndex(int seriesIndex) {
        this.seriesIndex = seriesIndex;
    }
}

