/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.bean.stack.writer;

import java.nio.file.Path;
import java.util.Optional;
import org.anchoranalysis.bean.AnchorBean;
import org.anchoranalysis.core.format.ImageFileFormat;
import org.anchoranalysis.core.log.Logger;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.ImageIOException;
import org.anchoranalysis.image.io.stack.output.StackWriteOptions;

public abstract class StackWriter
extends AnchorBean<StackWriter> {
    public Path writeStackWithExtension(Stack stack, Path filePath, StackWriteOptions options) throws ImageIOException {
        String fileNameWithExtension = filePath.getFileName() + "." + this.fileFormat(options).getDefaultExtension();
        Path filePathWithExtension = filePath.resolveSibling(fileNameWithExtension);
        this.writeStack(stack, filePathWithExtension, options);
        return filePathWithExtension;
    }

    public ImageFileFormat fileFormatWarnUnexpected(StackWriteOptions writeOptions, Optional<Logger> logger) throws ImageIOException {
        ImageFileFormat formatToWrite = this.fileFormat(writeOptions);
        Optional<ImageFileFormat> suggested = writeOptions.getSuggestedFormatToWrite();
        if (suggested.isPresent() && logger.isPresent() && !formatToWrite.equals((Object)suggested.get())) {
            logger.get().errorReporter().recordWarningFormatted("Although output format %s was requested, %s was used instead, as %s is not compatible with %s images.", new Object[]{suggested.get().toString(), formatToWrite.toString(), suggested.get().toString(), writeOptions.getAttributes().toString()});
        }
        return formatToWrite;
    }

    public abstract ImageFileFormat fileFormat(StackWriteOptions var1) throws ImageIOException;

    public abstract void writeStack(Stack var1, Path var2, StackWriteOptions var3) throws ImageIOException;
}

