/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.channel.input;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.anchoranalysis.image.io.bean.channel.IndexedChannel;

public class ChannelMap {
    private Map<String, IndexedChannel> map = new LinkedHashMap<String, IndexedChannel>();

    public void add(IndexedChannel channel) {
        this.map.put(channel.getName(), channel);
    }

    public int get(String name) {
        IndexedChannel entry = this.map.get(name);
        if (entry != null) {
            return entry.getIndex();
        }
        return -1;
    }

    public int getException(String name) {
        int ind = this.get(name);
        if (ind != -1) {
            return ind;
        }
        throw new IndexOutOfBoundsException(String.format("No channel index for '%s' in map", name));
    }

    public Set<String> names() {
        return this.map.keySet();
    }

    public Collection<IndexedChannel> values() {
        return this.map.values();
    }
}

