/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.object.input;

import java.nio.file.Path;
import org.anchoranalysis.core.format.NonImageFileFormat;
import org.anchoranalysis.core.serialize.DeserializationFailedException;
import org.anchoranalysis.core.serialize.Deserializer;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.image.io.object.input.ReadObjectsFromHDF5;
import org.anchoranalysis.image.voxel.object.ObjectCollection;

public class ObjectCollectionReader {
    private static final Deserializer<ObjectCollection> HDF5 = new ReadObjectsFromHDF5();

    public static ObjectCollection createFromPath(Path path, OperationContext context) throws DeserializationFailedException {
        if (ObjectCollectionReader.hasHdf5Extension(path)) {
            if (path.toFile().exists()) {
                return (ObjectCollection)HDF5.deserialize(path, context);
            }
            throw new DeserializationFailedException("File not found at " + path);
        }
        Path suffixed = ObjectCollectionReader.addHdf5Extension(path);
        if (suffixed.toFile().exists()) {
            return (ObjectCollection)HDF5.deserialize(suffixed, context);
        }
        throw new DeserializationFailedException("A HD5 file does not exist at: " + path);
    }

    public static boolean hasHdf5Extension(Path path) {
        return NonImageFileFormat.HDF5.matches(path);
    }

    private static Path addHdf5Extension(Path path) {
        return path.resolveSibling(path.getFileName() + NonImageFileFormat.HDF5.extensionWithPeriod());
    }

    private ObjectCollectionReader() {
    }
}

