/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.object.input;

import ch.systemsx.cisd.base.mdarray.MDByteArray;
import ch.systemsx.cisd.hdf5.IHDF5IntReader;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.factory.VoxelsFactory;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.box.BoundingBox;
import org.anchoranalysis.spatial.box.Extent;
import org.anchoranalysis.spatial.point.Point3i;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

class ObjectMaskHDF5Reader {
    public static ObjectMask readObject(IHDF5Reader reader, String datasetPath) {
        Voxels<UnsignedByteBuffer> voxels = ObjectMaskHDF5Reader.createVoxels(reader.uint8().readMDArray(datasetPath));
        BoundingBox box = BoundingBox.createReuse((ReadableTuple3i)ObjectMaskHDF5Reader.cornerPoint(reader.uint32(), datasetPath), (Extent)voxels.extent());
        return new ObjectMask(box, voxels);
    }

    private static Voxels<UnsignedByteBuffer> createVoxels(MDByteArray source) {
        Extent extent = ObjectMaskHDF5Reader.extractExtent(source);
        Voxels voxels = VoxelsFactory.getUnsignedByte().createInitialized(extent);
        for (int z = 0; z < extent.z(); ++z) {
            UnsignedByteBuffer buffer = (UnsignedByteBuffer)voxels.sliceBuffer(z);
            for (int y = 0; y < extent.y(); ++y) {
                for (int x = 0; x < extent.x(); ++x) {
                    buffer.putRaw(extent.offset(x, y), source.get(x, y, z));
                }
            }
        }
        return voxels;
    }

    private static Point3i cornerPoint(IHDF5IntReader reader, String path) {
        return new Point3i(ObjectMaskHDF5Reader.extractIntAttr(reader, path, "x"), ObjectMaskHDF5Reader.extractIntAttr(reader, path, "y"), ObjectMaskHDF5Reader.extractIntAttr(reader, path, "z"));
    }

    private static int extractIntAttr(IHDF5IntReader reader, String path, String attr) {
        return reader.getAttr(path, attr);
    }

    private static Extent extractExtent(MDByteArray array) {
        int[] dims = array.dimensions();
        return new Extent(dims[0], dims[1], dims[2]);
    }

    private ObjectMaskHDF5Reader() {
    }
}

