/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.object.input;

import ch.systemsx.cisd.hdf5.HDF5Factory;
import ch.systemsx.cisd.hdf5.IHDF5Reader;
import ch.systemsx.cisd.hdf5.exceptions.HDF5FileNotFoundException;
import com.github.davidmoten.guavamini.Preconditions;
import java.nio.file.Path;
import java.util.List;
import org.anchoranalysis.core.serialize.DeserializationFailedException;
import org.anchoranalysis.core.serialize.Deserializer;
import org.anchoranalysis.core.time.OperationContext;
import org.anchoranalysis.image.io.object.input.ObjectMaskHDF5Reader;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectCollectionFactory;

class ReadObjectsFromHDF5
implements Deserializer<ObjectCollection> {
    ReadObjectsFromHDF5() {
    }

    public ObjectCollection deserialize(Path path, OperationContext context) throws DeserializationFailedException {
        ObjectCollection objectCollection;
        block9: {
            IHDF5Reader reader = HDF5Factory.openForReading((String)path.toString());
            try {
                objectCollection = this.readObjects(reader, "/ObjMaskCollection/");
                if (reader == null) break block9;
            }
            catch (Throwable throwable) {
                try {
                    if (reader != null) {
                        try {
                            reader.close();
                        }
                        catch (Throwable throwable2) {
                            throwable.addSuppressed(throwable2);
                        }
                    }
                    throw throwable;
                }
                catch (HDF5FileNotFoundException e) {
                    throw new DeserializationFailedException(String.format("HDF5 file not found at %s", path));
                }
                catch (Exception e) {
                    throw new DeserializationFailedException(String.format("An error occurred while reading HDF5 at %s with rootPath=%s", path, "/ObjMaskCollection/"), (Throwable)e);
                }
            }
            reader.close();
        }
        return objectCollection;
    }

    private ObjectCollection readObjects(IHDF5Reader reader, String rootPath) throws DeserializationFailedException {
        Preconditions.checkArgument((boolean)rootPath.endsWith("/"));
        int numberObjects = reader.uint32().getAttr("/", "numberObjects");
        if (numberObjects == 0) {
            return ObjectCollectionFactory.empty();
        }
        ObjectCollection out = this.readObjectsNoCheck(reader, rootPath);
        if (out.size() != numberObjects) {
            throw new DeserializationFailedException(String.format("An error occurred deserializing HDF5, where %d objects were expected but %d were read.", numberObjects, out.size()));
        }
        return out;
    }

    private ObjectCollection readObjectsNoCheck(IHDF5Reader reader, String rootPath) {
        List groups = reader.object().getAllGroupMembers(rootPath);
        return ObjectCollectionFactory.mapFrom((Iterable)groups, groupName -> ObjectMaskHDF5Reader.readObject(reader, rootPath + groupName));
    }
}

