/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.object.output.grayscale;

import org.anchoranalysis.image.core.channel.Channel;
import org.anchoranalysis.image.core.channel.factory.ChannelFactoryUnsignedByte;
import org.anchoranalysis.image.core.dimensions.Dimensions;
import org.anchoranalysis.image.core.stack.Stack;
import org.anchoranalysis.image.io.channel.output.ChannelGenerator;
import org.anchoranalysis.image.io.object.output.grayscale.ObjectsAsGrayscaleGenerator;
import org.anchoranalysis.image.voxel.object.ObjectCollection;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.io.output.error.OutputWriteFailedException;

public class ObjectsAsUniqueValueGenerator
extends ObjectsAsGrayscaleGenerator {
    private static ChannelFactoryUnsignedByte factory = new ChannelFactoryUnsignedByte();

    public ObjectsAsUniqueValueGenerator(Dimensions dimensions) {
        super(dimensions);
    }

    public Stack transform(ObjectCollection element) throws OutputWriteFailedException {
        Channel out = factory.createEmptyInitialised(this.dimensions());
        if (element.size() > 254) {
            throw new OutputWriteFailedException(String.format("Collection has %d objects. A max of 254 is allowed", element.size()));
        }
        int value = 1;
        for (ObjectMask object : element) {
            out.assignValue(value++).toObject(object);
        }
        return new ChannelGenerator().transform(out);
    }
}

