/*
 * Decompiled with CFR 0.152.
 */
package org.anchoranalysis.image.io.object.output.hdf5;

import ch.systemsx.cisd.base.mdarray.MDByteArray;
import ch.systemsx.cisd.hdf5.HDF5IntStorageFeatures;
import ch.systemsx.cisd.hdf5.IHDF5Writer;
import java.util.function.ToIntFunction;
import org.anchoranalysis.image.voxel.Voxels;
import org.anchoranalysis.image.voxel.binary.BinaryVoxels;
import org.anchoranalysis.image.voxel.buffer.primitive.UnsignedByteBuffer;
import org.anchoranalysis.image.voxel.iterator.IterateVoxelsAll;
import org.anchoranalysis.image.voxel.object.ObjectMask;
import org.anchoranalysis.spatial.point.ReadableTuple3i;

class ObjectMaskHDF5Writer {
    private final ObjectMask object;
    private final String pathHDF5;
    private final IHDF5Writer writer;
    private final boolean compression;

    private HDF5IntStorageFeatures compressionLevel() {
        if (this.compression) {
            return HDF5IntStorageFeatures.INT_DEFLATE_UNSIGNED;
        }
        return HDF5IntStorageFeatures.INT_NO_COMPRESSION_UNSIGNED;
    }

    public void writeObject() {
        this.writer.uint8().writeMDArray(this.pathHDF5, ObjectMaskHDF5Writer.byteArray((BinaryVoxels<UnsignedByteBuffer>)this.object.binaryVoxels()), this.compressionLevel());
        this.addCorner();
    }

    private void addCorner() {
        this.addIntAttribute("x", ReadableTuple3i::x);
        this.addIntAttribute("y", ReadableTuple3i::y);
        this.addIntAttribute("z", ReadableTuple3i::z);
    }

    private void addIntAttribute(String name, ToIntFunction<ReadableTuple3i> extractValue) {
        Integer value = extractValue.applyAsInt(this.object.boundingBox().cornerMin());
        this.writer.uint32().setAttr(this.pathHDF5, name, value.intValue());
    }

    private static MDByteArray byteArray(BinaryVoxels<UnsignedByteBuffer> voxels) {
        MDByteArray array = new MDByteArray(voxels.extent().toArray());
        IterateVoxelsAll.withBuffer((Voxels)voxels.voxels(), (point, buffer, offset) -> array.set(buffer.getRaw(offset), point.x(), point.y(), point.z()));
        return array;
    }

    public ObjectMaskHDF5Writer(ObjectMask object, String pathHDF5, IHDF5Writer writer, boolean compression) {
        this.object = object;
        this.pathHDF5 = pathHDF5;
        this.writer = writer;
        this.compression = compression;
    }
}

